/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.user.service.provider;

import javax.inject.Provider;
import org.eurekaclinical.user.service.config.UserServiceProperties;
import org.scribe.up.provider.BaseOAuthProvider;

public abstract class AbstractOAuthProvider<E extends BaseOAuthProvider>
implements Provider<E> {
    private final Class<E> oAuthProviderCls;
    private final UserServiceProperties properties;
    private final String callbackPath;

    AbstractOAuthProvider(UserServiceProperties inProperties, Class<E> inOAuthProviderCls, String inCallbackPath) {
        this.oAuthProviderCls = inOAuthProviderCls;
        this.properties = inProperties;
        this.callbackPath = inCallbackPath;
    }

    public E get() {
        try {
            BaseOAuthProvider oAuthProvider = (BaseOAuthProvider)this.oAuthProviderCls.newInstance();
            oAuthProvider.setKey(this.getKey());
            oAuthProvider.setSecret(this.getSecret());
            oAuthProvider.setCallbackUrl(this.callbackPath);
            return (E)oAuthProvider;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new AssertionError("Can't create provider", ex);
        }
    }

    UserServiceProperties getProperties() {
        return this.properties;
    }

    abstract String getKey();

    abstract String getSecret();
}

