/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.user.service.resource;

import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eurekaclinical.standardapis.exception.HttpStatusException;
import org.eurekaclinical.user.client.comm.AuthenticationMethod;
import org.eurekaclinical.user.service.dao.AuthenticationMethodDao;
import org.eurekaclinical.user.service.entity.AuthenticationMethodEntity;

@Transactional
@Path(value="/protected/authenticationmethods")
@Produces(value={"application/json"})
public class AuthenticationMethodResource {
    private final AuthenticationMethodDao authenticationMethodDao;

    @Inject
    public AuthenticationMethodResource(AuthenticationMethodDao inAuthenticationMethodDao) {
        this.authenticationMethodDao = inAuthenticationMethodDao;
    }

    @GET
    public List<AuthenticationMethod> getAll() {
        List authenticationMethodEntities = this.authenticationMethodDao.getAll();
        ArrayList<AuthenticationMethod> authenticationMethods = new ArrayList<AuthenticationMethod>(authenticationMethodEntities.size());
        for (AuthenticationMethodEntity authenticationMethodEntity : authenticationMethodEntities) {
            authenticationMethods.add(authenticationMethodEntity.toAuthenticationMethod());
        }
        return authenticationMethods;
    }

    @GET
    @Path(value="/{id}")
    public AuthenticationMethod get(@PathParam(value="id") Long inId) {
        AuthenticationMethodEntity authenticationMethodEntity = (AuthenticationMethodEntity)this.authenticationMethodDao.retrieve((Object)inId);
        if (authenticationMethodEntity == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        return authenticationMethodEntity.toAuthenticationMethod();
    }

    @GET
    @Path(value="/byname/{name}")
    public AuthenticationMethod getByName(@PathParam(value="name") String inName) {
        AuthenticationMethodEntity authenticationMethodEntity = this.authenticationMethodDao.getByName(org.eurekaclinical.user.client.comm.authentication.AuthenticationMethod.valueOf((String)inName));
        if (authenticationMethodEntity == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        return authenticationMethodEntity.toAuthenticationMethod();
    }
}

