/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.user.service.resource;

import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eurekaclinical.standardapis.exception.HttpStatusException;
import org.eurekaclinical.user.client.comm.LoginType;
import org.eurekaclinical.user.service.dao.LoginTypeDao;
import org.eurekaclinical.user.service.entity.LoginTypeEntity;

@Transactional
@Path(value="/protected/logintypes")
@Produces(value={"application/json"})
public class LoginTypeResource {
    private final LoginTypeDao loginTypeDao;

    @Inject
    public LoginTypeResource(LoginTypeDao thresholdsOpDao) {
        this.loginTypeDao = thresholdsOpDao;
    }

    @GET
    @Path(value="")
    public List<LoginType> getAll() {
        List loginTypeEntities = this.loginTypeDao.getAll();
        ArrayList<LoginType> loginTypes = new ArrayList<LoginType>(loginTypeEntities.size());
        for (LoginTypeEntity loginTypeEntity : loginTypeEntities) {
            loginTypes.add(loginTypeEntity.toLoginType());
        }
        return loginTypes;
    }

    @GET
    @Path(value="/{id}")
    public LoginType get(@PathParam(value="id") Long inId) {
        LoginTypeEntity loginTypeEntity = (LoginTypeEntity)this.loginTypeDao.retrieve((Object)inId);
        if (loginTypeEntity == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        return loginTypeEntity.toLoginType();
    }

    @GET
    @Path(value="/byname/{name}")
    public LoginType getByName(@PathParam(value="name") String inName) {
        LoginTypeEntity loginTypeEntity = this.loginTypeDao.getByName(org.eurekaclinical.user.client.comm.authentication.LoginType.valueOf((String)inName));
        if (loginTypeEntity == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        return loginTypeEntity.toLoginType();
    }
}

