/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.user.service.resource;

import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eurekaclinical.user.service.dao.OAuthProviderDao;
import org.eurekaclinical.user.service.entity.OAuthProviderEntity;

@Transactional
@Path(value="/protected/oauthproviders")
@Produces(value={"application/json"})
public class OAuthProviderResource {
    private final OAuthProviderDao oauthProviderDao;

    @Inject
    public OAuthProviderResource(OAuthProviderDao oauthProviderDao) {
        this.oauthProviderDao = oauthProviderDao;
    }

    @GET
    public List<OAuthProviderEntity> getAll() {
        return this.oauthProviderDao.getAll();
    }

    @GET
    @Path(value="/{id}")
    public OAuthProviderEntity get(@PathParam(value="id") Long inId) {
        return (OAuthProviderEntity)this.oauthProviderDao.retrieve((Object)inId);
    }

    @GET
    @Path(value="/byname/{name}")
    public OAuthProviderEntity getByName(@PathParam(value="name") String inName) {
        return this.oauthProviderDao.getByName(inName);
    }
}

