/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.user.service.resource;

import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.eurekaclinical.standardapis.exception.HttpStatusException;
import org.eurekaclinical.user.client.comm.UserRequest;
import org.eurekaclinical.user.client.comm.UserRequestVisitor;
import org.eurekaclinical.user.service.dao.AuthenticationMethodDao;
import org.eurekaclinical.user.service.dao.LocalUserDao;
import org.eurekaclinical.user.service.dao.LoginTypeDao;
import org.eurekaclinical.user.service.dao.OAuthProviderDao;
import org.eurekaclinical.user.service.dao.RoleDao;
import org.eurekaclinical.user.service.dao.UserDao;
import org.eurekaclinical.user.service.email.EmailException;
import org.eurekaclinical.user.service.email.EmailSender;
import org.eurekaclinical.user.service.entity.LocalUserEntity;
import org.eurekaclinical.user.service.entity.UserEntity;
import org.eurekaclinical.user.service.util.UserRequestToUserEntityVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Transactional
@Path(value="/userrequests")
public class UserRequestResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserRequestResource.class);
    private final UserDao userDao;
    private final LocalUserDao localUserDao;
    private final EmailSender emailSender;
    private final UserRequestToUserEntityVisitor visitor;

    @Inject
    public UserRequestResource(UserDao inUserDao, LocalUserDao inLocalUserDao, RoleDao inRoleDao, EmailSender inEmailSender, OAuthProviderDao inOAuthProviderDao, LoginTypeDao inLoginTypeDao, AuthenticationMethodDao inAuthenticationMethodDao) {
        this.userDao = inUserDao;
        this.localUserDao = inLocalUserDao;
        this.emailSender = inEmailSender;
        this.visitor = new UserRequestToUserEntityVisitor(inOAuthProviderDao, inRoleDao, inLoginTypeDao, inAuthenticationMethodDao);
    }

    @POST
    @Consumes(value={"application/json"})
    public Response addUser(UserRequest userRequest, @Context UriInfo uriInfo) {
        UserEntity user = (UserEntity)this.userDao.getByName(userRequest.getUsername());
        if (user != null) {
            throw new HttpStatusException(Response.Status.CONFLICT, "That username is already taken");
        }
        Object[] errors = userRequest.validate();
        if (errors.length == 0) {
            userRequest.accept((UserRequestVisitor)this.visitor);
            UserEntity userEntity = this.visitor.getUserEntity();
            LOGGER.debug("Saving new user {}", (Object)userEntity.getUsername());
            this.userDao.create((Object)userEntity);
            if (userEntity instanceof LocalUserEntity) {
                try {
                    LOGGER.debug("Sending email to {}", (Object)userEntity.getEmail());
                    this.emailSender.sendVerificationMessage(userEntity);
                }
                catch (EmailException e) {
                    LOGGER.error("Error sending email to {}", (Object)userEntity.getEmail(), (Object)e);
                }
            }
            URI uri = uriInfo.getAbsolutePathBuilder().path(userEntity.getId().toString()).build(new Object[0]);
            return Response.created((URI)uri).entity((Object)user).build();
        }
        String errorMsg = StringUtils.join((Object[])errors, (String)", ");
        LOGGER.info("Invalid new user request: {}, reason {}", (Object)userRequest.getEmail(), (Object)errorMsg);
        throw new HttpStatusException(Response.Status.BAD_REQUEST, errorMsg);
    }

    @Path(value="/verify/{code}")
    @PUT
    public void verifyUser(@PathParam(value="code") String code) {
        LocalUserEntity user = this.localUserDao.getByVerificationCode(code);
        if (user == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        user.setVerified(true);
        this.localUserDao.update((Object)user);
    }
}

