/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.user.service.resource;

import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.eurekaclinical.standardapis.exception.HttpStatusException;
import org.eurekaclinical.user.client.comm.PasswordChangeRequest;
import org.eurekaclinical.user.client.comm.User;
import org.eurekaclinical.user.client.comm.UserVisitor;
import org.eurekaclinical.user.service.dao.AuthenticationMethodDao;
import org.eurekaclinical.user.service.dao.LocalUserDao;
import org.eurekaclinical.user.service.dao.LoginTypeDao;
import org.eurekaclinical.user.service.dao.OAuthProviderDao;
import org.eurekaclinical.user.service.dao.RoleDao;
import org.eurekaclinical.user.service.dao.UserDao;
import org.eurekaclinical.user.service.email.EmailException;
import org.eurekaclinical.user.service.email.EmailSender;
import org.eurekaclinical.user.service.entity.LocalUserEntity;
import org.eurekaclinical.user.service.entity.RoleEntity;
import org.eurekaclinical.user.service.entity.UserEntity;
import org.eurekaclinical.user.service.entity.UserEntityToUserVisitor;
import org.eurekaclinical.user.service.entity.UserEntityVisitor;
import org.eurekaclinical.user.service.util.StringUtil;
import org.eurekaclinical.user.service.util.UserToUserEntityVisitor;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Transactional
@Path(value="/protected/users")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class UserResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserResource.class);
    private final UserDao userDao;
    private final LocalUserDao localUserDao;
    private final RoleDao roleDao;
    private final EmailSender emailSender;
    private String validationError;
    private UserToUserEntityVisitor visitor;

    @Inject
    public UserResource(UserDao inUserDao, LocalUserDao inLocalUserDao, RoleDao inRoleDao, EmailSender inEmailSender, OAuthProviderDao inOAuthProviderDao, LoginTypeDao inLoginTypeDao, AuthenticationMethodDao inAuthenticationMethodDao) {
        this.userDao = inUserDao;
        this.localUserDao = inLocalUserDao;
        this.roleDao = inRoleDao;
        this.emailSender = inEmailSender;
        this.visitor = new UserToUserEntityVisitor(inOAuthProviderDao, inRoleDao, inLoginTypeDao, inAuthenticationMethodDao);
    }

    @RolesAllowed(value={"admin"})
    @GET
    public List<User> getUsers() {
        List users = this.userDao.getAll();
        LOGGER.debug("Returning list of users");
        UserEntityToUserVisitor visitor = new UserEntityToUserVisitor();
        visitor.visit((Collection)users);
        return visitor.getUsers();
    }

    @RolesAllowed(value={"researcher", "admin"})
    @Path(value="/{id}")
    @GET
    public User getUserById(@Context HttpServletRequest req, @PathParam(value="id") Long inId) {
        UserEntity userEntity = (UserEntity)this.userDao.retrieve((Object)inId);
        if (userEntity == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        if (!req.isUserInRole("admin") && !req.getRemoteUser().equals(userEntity.getUsername())) {
            throw new HttpStatusException(Response.Status.FORBIDDEN);
        }
        this.userDao.refresh((Object)userEntity);
        LOGGER.debug("Returning user for ID {}", (Object)inId);
        UserEntityToUserVisitor visitor = new UserEntityToUserVisitor();
        userEntity.accept((UserEntityVisitor)visitor);
        return visitor.getUser();
    }

    @RolesAllowed(value={"researcher", "admin"})
    @Path(value="/me")
    @GET
    public User getMe(@Context HttpServletRequest req) {
        AttributePrincipal principal = (AttributePrincipal)req.getUserPrincipal();
        String username = principal.getName();
        UserEntity userEntity = (UserEntity)this.userDao.getByName(username);
        if (userEntity == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        this.userDao.refresh((Object)userEntity);
        LOGGER.debug("Returning user for name {}", (Object)username);
        UserEntityToUserVisitor visitor = new UserEntityToUserVisitor();
        userEntity.accept((UserEntityVisitor)visitor);
        return visitor.getUser();
    }

    @RolesAllowed(value={"admin"})
    @POST
    public Response addUser(User user, @Context UriInfo uriInfo) {
        if (this.userDao.getByName(user.getUsername()) != null) {
            throw new HttpStatusException(Response.Status.CONFLICT);
        }
        Object[] errors = user.validate();
        if (errors.length == 0) {
            user.accept((UserVisitor)this.visitor);
            UserEntity userEntity = this.visitor.getUserEntity();
            LOGGER.debug("Saving new user {}", (Object)userEntity.getEmail());
            this.userDao.create((Object)userEntity);
            try {
                LOGGER.debug("Sending email to {}", (Object)userEntity.getEmail());
                this.emailSender.sendActivationMessage(userEntity);
            }
            catch (EmailException e) {
                LOGGER.error("Error sending email to {}", (Object)userEntity.getEmail(), (Object)e);
            }
        } else {
            LOGGER.info("Invalid new user request: {}, reason {}", (Object)user, (Object)this.validationError);
            throw new HttpStatusException(Response.Status.BAD_REQUEST, StringUtils.join((Object[])errors, (String)", "));
        }
        UserEntity addedUser = (UserEntity)this.userDao.getByName(user.getUsername());
        URI uri = uriInfo.getAbsolutePathBuilder().path(addedUser.getId().toString()).build(new Object[0]);
        return Response.created((URI)uri).entity((Object)user).build();
    }

    @RolesAllowed(value={"researcher", "admin"})
    @Path(value="/passwordchange")
    @POST
    public Response changePassword(@Context HttpServletRequest request, PasswordChangeRequest passwordChangeRequest) {
        String newPasswordHash;
        String oldPasswordHash;
        String username = request.getUserPrincipal().getName();
        LocalUserEntity user = this.localUserDao.getByName(username);
        Response response = null;
        if (user == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        String newPassword = passwordChangeRequest.getNewPassword();
        try {
            oldPasswordHash = StringUtil.md5((String)passwordChangeRequest.getOldPassword());
            newPasswordHash = StringUtil.md5((String)newPassword);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        if (user.getPassword().equals(oldPasswordHash)) {
            user.setPassword(newPasswordHash);
            user.setPasswordExpiration(this.getExpirationDate());
            this.localUserDao.update((Object)user);
            try {
                this.emailSender.sendPasswordChangeMessage((UserEntity)user);
                response = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            catch (EmailException ee) {
                LOGGER.error(ee.getMessage(), (Throwable)ee);
            }
        } else {
            throw new HttpStatusException(Response.Status.BAD_REQUEST, "Error while changing password. Old password is incorrect.");
        }
        return response;
    }

    @RolesAllowed(value={"researcher", "admin"})
    @Path(value="/{id}")
    @PUT
    public Response putUser(@Context HttpServletRequest req, User inUser, @PathParam(value="id") Long inId) {
        Response response;
        boolean activation;
        String username = req.getUserPrincipal().getName();
        if (!req.isUserInRole("admin") && !username.equals(inUser.getUsername())) {
            throw new HttpStatusException(Response.Status.FORBIDDEN);
        }
        LOGGER.debug("Received updated user: {}", (Object)inUser);
        UserEntity currentUser = (UserEntity)this.userDao.retrieve((Object)inId);
        User me = this.getMe(req);
        boolean bl = activation = !currentUser.isActive() && inUser.isActive();
        if (this.validateUpdatedUser(currentUser, inUser, me)) {
            currentUser.setFirstName(inUser.getFirstName());
            currentUser.setLastName(inUser.getLastName());
            currentUser.setEmail(inUser.getEmail());
            currentUser.setOrganization(inUser.getOrganization());
            currentUser.setTitle(inUser.getTitle());
            currentUser.setDepartment(inUser.getDepartment());
            currentUser.setFullName(inUser.getFullName());
            List updatedRoles = this.roleIdsToRoles(inUser.getRoles());
            currentUser.setRoles(updatedRoles);
            currentUser.setActive(inUser.isActive());
            currentUser.setLastLogin(inUser.getLastLogin());
            LOGGER.debug("Saving updated user: {}", (Object)currentUser.getEmail());
            this.userDao.update((Object)currentUser);
            if (activation) {
                try {
                    this.emailSender.sendActivationMessage(currentUser);
                }
                catch (EmailException ee) {
                    LOGGER.error(ee.getMessage(), (Throwable)ee);
                }
            }
            response = Response.ok().entity((Object)currentUser).build();
        } else {
            response = Response.notModified((String)this.validationError).build();
        }
        return response;
    }

    private boolean validateUpdatedUser(UserEntity currentUser, User inUser, User me) {
        boolean result = true;
        boolean updateByMe = true;
        RoleEntity adminUserRole = (RoleEntity)this.roleDao.getByName("admin");
        updateByMe = me.getUsername().equals(currentUser.getUsername());
        if (currentUser.getRoles().contains(adminUserRole) && updateByMe) {
            if (!inUser.getRoles().contains(2L)) {
                this.validationError = "admin user can not be stripped of admin rights by him/herself ";
                result = false;
            } else if (currentUser.isActive() && !inUser.isActive()) {
                this.validationError = "admin user can not be de-activated by him/herself";
                result = false;
            }
        }
        return result;
    }

    private Date getExpirationDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 90);
        return calendar.getTime();
    }

    private List<RoleEntity> roleIdsToRoles(List<Long> inRoleIds) {
        ArrayList<RoleEntity> roles = new ArrayList<RoleEntity>(inRoleIds.size());
        for (Long roleId : inRoleIds) {
            roles.add((RoleEntity)this.roleDao.retrieve((Object)roleId));
        }
        return roles;
    }
}

