/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.user.service.util;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.eurekaclinical.scribeupext.profile.EurekaProfile;
import org.eurekaclinical.standardapis.exception.HttpStatusException;
import org.eurekaclinical.user.service.util.PersonNameSplitter;
import org.eurekaclinical.user.service.util.RegistrationOAuthUserProfile;
import org.scribe.up.credential.OAuthCredential;
import org.scribe.up.provider.OAuthProvider;
import org.scribe.up.session.HttpUserSession;
import org.scribe.up.session.UserSession;

public class AbstractOAuthRegistrationUserResource<E extends EurekaProfile> {
    private final OAuthProvider provider;

    public AbstractOAuthRegistrationUserResource(OAuthProvider oauthProvider) {
        assert (oauthProvider != null) : "provider cannot be null";
        this.provider = oauthProvider;
    }

    public E getEurekaProfile(HttpServletRequest req) throws HttpStatusException {
        assert (req != null) : "request cannot be null";
        OAuthCredential credential = this.provider.getCredential((UserSession)new HttpUserSession(req.getSession()), req.getParameterMap());
        if (credential == null) {
            throw new HttpStatusException(Response.Status.BAD_REQUEST, "No valid oauth credential found");
        }
        EurekaProfile profile = (EurekaProfile)this.provider.getUserProfile(credential);
        if (profile == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND, "Couldn't retrieve user profile");
        }
        return (E)profile;
    }

    public RegistrationOAuthUserProfile getRegistrationOAuthProfile(HttpServletRequest req) throws HttpStatusException {
        RegistrationOAuthUserProfile oauthProfile = new RegistrationOAuthUserProfile();
        EurekaProfile profile = this.getEurekaProfile(req);
        String fullName = profile.getDisplayName();
        String firstName = profile.getFirstName();
        String lastName = profile.getFamilyName();
        if ((firstName == null || lastName == null) && fullName != null) {
            PersonNameSplitter splitter = new PersonNameSplitter(fullName);
            if (firstName == null) {
                firstName = splitter.getFirstName();
            }
            if (lastName == null) {
                lastName = splitter.getLastName();
            }
        }
        oauthProfile.setFirstName(firstName);
        oauthProfile.setLastName(lastName);
        oauthProfile.setUserName(profile.getTypedId());
        oauthProfile.setEmail(profile.getEmail());
        oauthProfile.setProviderUsername(profile.getUsername());
        oauthProfile.setProvider(this.provider.getType());
        return oauthProfile;
    }
}

