/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.user.service.util;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.eurekaclinical.standardapis.exception.HttpStatusException;
import org.eurekaclinical.user.client.comm.LdapUserRequest;
import org.eurekaclinical.user.client.comm.LocalUserRequest;
import org.eurekaclinical.user.client.comm.OAuthUserRequest;
import org.eurekaclinical.user.client.comm.UserRequest;
import org.eurekaclinical.user.client.comm.UserRequestVisitor;
import org.eurekaclinical.user.service.dao.AuthenticationMethodDao;
import org.eurekaclinical.user.service.dao.LoginTypeDao;
import org.eurekaclinical.user.service.dao.OAuthProviderDao;
import org.eurekaclinical.user.service.dao.RoleDao;
import org.eurekaclinical.user.service.entity.LocalUserEntity;
import org.eurekaclinical.user.service.entity.OAuthUserEntity;
import org.eurekaclinical.user.service.entity.RoleEntity;
import org.eurekaclinical.user.service.entity.UserEntity;
import org.eurekaclinical.user.service.entity.UserEntityFactory;
import org.eurekaclinical.user.service.util.StringUtil;

public class UserRequestToUserEntityVisitor
implements UserRequestVisitor {
    private UserEntity userEntity;
    private final OAuthProviderDao oauthProviderDao;
    private final RoleDao roleDao;
    private final UserEntityFactory userEntityFactory;
    private final LoginTypeDao loginTypeDao;
    private final AuthenticationMethodDao authenticationMethodDao;

    public UserRequestToUserEntityVisitor(OAuthProviderDao inOAuthProviderDao, RoleDao inRoleDao, LoginTypeDao inLoginTypeDao, AuthenticationMethodDao inAuthenticationMethodDao) {
        this.oauthProviderDao = inOAuthProviderDao;
        this.roleDao = inRoleDao;
        this.loginTypeDao = inLoginTypeDao;
        this.authenticationMethodDao = inAuthenticationMethodDao;
        this.userEntityFactory = new UserEntityFactory(this.loginTypeDao, this.authenticationMethodDao);
    }

    public void visit(LocalUserRequest localUserRequest) {
        LocalUserEntity localUserEntity = this.userEntityFactory.getLocalUserEntityInstance();
        this.populateUserEntityFields((UserEntity)localUserEntity, (UserRequest)localUserRequest);
        try {
            localUserEntity.setPassword(StringUtil.md5((String)localUserRequest.getPassword()));
        }
        catch (NoSuchAlgorithmException e1) {
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e1);
        }
        Calendar cal = Calendar.getInstance();
        cal.add(2, 12);
        localUserEntity.setPasswordExpiration(cal.getTime());
        localUserEntity.setVerificationCode(UUID.randomUUID().toString());
        localUserEntity.setVerified(false);
        this.userEntity = localUserEntity;
    }

    public void visit(LdapUserRequest ldapUserRequest) {
        this.userEntity = this.userEntityFactory.getLdapUserEntityInstance();
        this.populateUserEntityFields(this.userEntity, (UserRequest)ldapUserRequest);
    }

    public void visit(OAuthUserRequest oauthUserRequest) {
        OAuthUserEntity oauthUserEntity = this.userEntityFactory.getOAuthUserEntityInstance();
        this.populateUserEntityFields((UserEntity)oauthUserEntity, (UserRequest)oauthUserRequest);
        oauthUserEntity.setProviderUsername(oauthUserRequest.getProviderUsername());
        oauthUserEntity.setOAuthProvider(this.oauthProviderDao.getByName(oauthUserRequest.getOAuthProvider()));
        this.userEntity = oauthUserEntity;
    }

    public UserEntity getUserEntity() {
        return this.userEntity;
    }

    private void populateUserEntityFields(UserEntity userEntity, UserRequest userRequest) {
        userEntity.setUsername(userRequest.getUsername());
        userEntity.setEmail(userRequest.getEmail());
        userEntity.setFirstName(userRequest.getFirstName());
        userEntity.setLastName(userRequest.getLastName());
        userEntity.setFullName(userRequest.getFullName());
        userEntity.setDepartment(userRequest.getDepartment());
        userEntity.setCreated(new Date());
        userEntity.setOrganization(userRequest.getOrganization());
        userEntity.setRoles(this.getDefaultRoles());
        userEntity.setTitle(userRequest.getTitle());
        userEntity.setActive(false);
    }

    private List<RoleEntity> getDefaultRoles() {
        ArrayList<RoleEntity> defaultRoles = new ArrayList<RoleEntity>();
        for (RoleEntity role : this.roleDao.getAll()) {
            if (!Boolean.TRUE.equals(role.isDefaultRole())) continue;
            defaultRoles.add(role);
        }
        return defaultRoles;
    }
}

