/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.user.service.util;

import java.util.ArrayList;
import java.util.List;
import org.eurekaclinical.user.client.comm.LdapUser;
import org.eurekaclinical.user.client.comm.LocalUser;
import org.eurekaclinical.user.client.comm.OAuthUser;
import org.eurekaclinical.user.client.comm.User;
import org.eurekaclinical.user.client.comm.UserVisitor;
import org.eurekaclinical.user.service.dao.AuthenticationMethodDao;
import org.eurekaclinical.user.service.dao.LoginTypeDao;
import org.eurekaclinical.user.service.dao.OAuthProviderDao;
import org.eurekaclinical.user.service.dao.RoleDao;
import org.eurekaclinical.user.service.entity.LocalUserEntity;
import org.eurekaclinical.user.service.entity.OAuthProviderEntity;
import org.eurekaclinical.user.service.entity.OAuthUserEntity;
import org.eurekaclinical.user.service.entity.UserEntity;
import org.eurekaclinical.user.service.entity.UserEntityFactory;

public class UserToUserEntityVisitor
implements UserVisitor {
    private final OAuthProviderDao oauthProviderDao;
    private final RoleDao roleDao;
    private UserEntity userEntity;
    private final UserEntityFactory userEntityFactory;
    private final LoginTypeDao loginTypeDao;
    private final AuthenticationMethodDao authenticationMethodDao;

    public UserToUserEntityVisitor(OAuthProviderDao inOAuthProviderDao, RoleDao inRoleDao, LoginTypeDao inLoginTypeDao, AuthenticationMethodDao inAuthenticationMethodDao) {
        this.oauthProviderDao = inOAuthProviderDao;
        this.roleDao = inRoleDao;
        this.loginTypeDao = inLoginTypeDao;
        this.authenticationMethodDao = inAuthenticationMethodDao;
        this.userEntityFactory = new UserEntityFactory(this.loginTypeDao, this.authenticationMethodDao);
    }

    public void visit(LocalUser localUser) {
        LocalUserEntity localUserEntity = this.userEntityFactory.getLocalUserEntityInstance();
        this.populateUserEntityFields((UserEntity)localUserEntity, (User)localUser);
        localUserEntity.setPassword(localUser.getPassword());
        localUserEntity.setPasswordExpiration(localUser.getPasswordExpiration());
        localUserEntity.setVerificationCode(localUser.getVerificationCode());
        localUserEntity.setVerified(localUser.isVerified());
        this.userEntity = localUserEntity;
    }

    public void visit(LdapUser ldapUser) {
        this.userEntity = this.userEntityFactory.getLdapUserEntityInstance();
        this.populateUserEntityFields(this.userEntity, (User)ldapUser);
    }

    public void visit(OAuthUser oauthUser) {
        OAuthUserEntity oauthUserEntity = this.userEntityFactory.getOAuthUserEntityInstance();
        this.populateUserEntityFields((UserEntity)oauthUserEntity, (User)oauthUser);
        oauthUserEntity.setProviderUsername(oauthUser.getProviderUsername());
        oauthUserEntity.setOAuthProvider((OAuthProviderEntity)this.oauthProviderDao.retrieve((Object)oauthUser.getOAuthProvider()));
        this.userEntity = oauthUserEntity;
    }

    public UserEntity getUserEntity() {
        return this.userEntity;
    }

    private void populateUserEntityFields(UserEntity userEntity, User user) {
        userEntity.setUsername(user.getUsername());
        userEntity.setEmail(user.getEmail());
        userEntity.setFirstName(user.getFirstName());
        userEntity.setLastName(user.getLastName());
        userEntity.setFullName(user.getFullName());
        userEntity.setDepartment(user.getDepartment());
        userEntity.setCreated(user.getCreated());
        userEntity.setOrganization(user.getOrganization());
        userEntity.setTitle(user.getTitle());
        List roleLongs = user.getRoles();
        ArrayList<Object> roles = new ArrayList<Object>(roleLongs.size());
        for (Long roleLong : roleLongs) {
            roles.add(this.roleDao.retrieve((Object)roleLong));
        }
        userEntity.setRoles(roles);
        userEntity.setActive(user.isActive());
    }
}

