/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.bp.commons;

import java.util.ArrayList;
import java.util.ServiceConfigurationError;
import org.arp.javautil.serviceloader.ClassServiceLoader;
import org.protempa.backend.Backend;
import org.protempa.backend.BackendNewInstanceException;
import org.protempa.backend.BackendProvider;
import org.protempa.backend.BackendProviderSpecLoaderException;
import org.protempa.backend.BackendSpecLoader;
import org.protempa.backend.asb.AlgorithmSourceBackend;
import org.protempa.backend.dsb.DataSourceBackend;
import org.protempa.backend.ksb.KnowledgeSourceBackend;
import org.protempa.backend.tsb.TermSourceBackend;
import org.protempa.bp.commons.BackendSpecFactory;
import org.protempa.bp.commons.CommonsUtil;
import org.protempa.bp.commons.InvalidBackendException;

public final class CommonsBackendProvider
implements BackendProvider {
    public String getDisplayName() {
        return CommonsUtil.resourceBundle().getString("displayName");
    }

    public BackendSpecLoader<DataSourceBackend> getDataSourceBackendSpecLoader() throws BackendProviderSpecLoaderException {
        return this.getBackendSpecLoader(DataSourceBackend.class);
    }

    public BackendSpecLoader<KnowledgeSourceBackend> getKnowledgeSourceBackendSpecLoader() throws BackendProviderSpecLoaderException {
        return this.getBackendSpecLoader(KnowledgeSourceBackend.class);
    }

    public BackendSpecLoader<AlgorithmSourceBackend> getAlgorithmSourceBackendSpecLoader() throws BackendProviderSpecLoaderException {
        return this.getBackendSpecLoader(AlgorithmSourceBackend.class);
    }

    public BackendSpecLoader<TermSourceBackend> getTermSourceBackendSpecLoader() throws BackendProviderSpecLoaderException {
        return this.getBackendSpecLoader(TermSourceBackend.class);
    }

    private <B extends Backend> BackendSpecLoader<B> getBackendSpecLoader(Class<B> clazz) throws BackendProviderSpecLoaderException {
        ArrayList backendSpecs = new ArrayList();
        ArrayList classNamesL = new ArrayList();
        try {
            classNamesL.addAll(ClassServiceLoader.load(clazz));
        }
        catch (ServiceConfigurationError ex) {
            throw new BackendProviderSpecLoaderException("Error loading backend " + clazz.getName(), (Throwable)ex);
        }
        for (Class className : classNamesL) {
            try {
                backendSpecs.add(BackendSpecFactory.newInstance(this, className));
            }
            catch (InvalidBackendException ex) {
                throw new BackendProviderSpecLoaderException("Backend " + className + " is invalid", (Throwable)((Object)ex));
            }
        }
        return new BackendSpecLoader(backendSpecs);
    }

    public Object newInstance(String resourceId) throws BackendNewInstanceException {
        try {
            return Class.forName(resourceId).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new BackendNewInstanceException((Throwable)ex);
        }
    }
}

