/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import org.evomaster.client.java.sql.internal.ParserUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ParserUtilsTest {
    @Disabled
    @Test
    public void testEscapeInput() {
        Assertions.assertTrue((boolean)ParserUtils.canParseSqlStatement((String)"SELECT * FROM Foo WHERE x LIKE '$a' ESCAPE '$'"));
        Assertions.assertTrue((boolean)ParserUtils.canParseSqlStatement((String)"SELECT * FROM Foo WHERE x LIKE  ?1 ESCAPE '$'"));
        Assertions.assertTrue((boolean)ParserUtils.canParseSqlStatement((String)"SELECT * FROM Foo WHERE x LIKE '$a' ESCAPE ?1"));
        Assertions.assertTrue((boolean)ParserUtils.canParseSqlStatement((String)"SELECT * FROM Foo WHERE x LIKE ?1 ESCAPE ?2"));
    }

    @Disabled
    @Test
    public void testRestartSequence() {
        String sql = "ALTER SEQUENCE SYSTEM_SEQUENCE_40560F88_80C4_4F3B_BDAA_D18CC8D5C5AA RESTART WITH 1";
        boolean parsed = ParserUtils.canParseSqlStatement((String)sql);
        Assertions.assertTrue((boolean)parsed);
    }

    @Disabled
    @Test
    public void testEmptyInsertValue() {
        String sql = "INSERT INTO Foo() VALUES()";
        boolean parsed = ParserUtils.canParseSqlStatement((String)sql);
        Assertions.assertTrue((boolean)parsed);
    }

    @ParameterizedTest
    @ValueSource(strings={"SELECT 1", "SELECT 1;", "Select    1;", "Select 1 ; "})
    public void testSelectOne(String sql) throws JSQLParserException {
        Statement s = CCJSqlParserUtil.parse((String)sql);
        Assertions.assertNotNull((Object)s);
        Expression where = ParserUtils.getWhere((Statement)s);
        Assertions.assertNull((Object)where);
        boolean isSelectOne = ParserUtils.isSelectOne((String)sql);
        Assertions.assertTrue((boolean)isSelectOne);
    }

    @Test
    public void testOnConflictPostgresql() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ParserUtils.asStatement((String)"INSERT INTO vets VALUES (1, 'James', 'Carter') ON CONFLICT DO NOTHING;"));
    }
}

