/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.EnumMap;
import org.evrete.api.KeyMode;
import org.evrete.api.MemoryKey;
import org.evrete.api.ReIterator;
import org.evrete.runtime.AbstractRuleSession;
import org.evrete.runtime.BetaMemoryNode;
import org.evrete.runtime.EntryNodeDescriptor;
import org.evrete.runtime.KeyMemoryBucket;
import org.evrete.runtime.MemoryKeyIterator;

public class BetaEntryNode
implements BetaMemoryNode {
    private final EntryNodeDescriptor descriptor;
    private final EnumMap<KeyMode, ReIterator<MemoryKey>> stores = new EnumMap(KeyMode.class);

    BetaEntryNode(AbstractRuleSession<?> runtime, EntryNodeDescriptor node) {
        this.descriptor = node;
        KeyMemoryBucket bucket = runtime.getMemory().getMemoryBucket(node.getFactType().getMemoryAddress());
        for (KeyMode mode : KeyMode.values()) {
            ReIterator<MemoryKey> delegate = bucket.getFieldData().keys(mode);
            MemoryKeyIterator mapped = new MemoryKeyIterator(delegate, mode);
            this.stores.put(mode, mapped);
        }
    }

    @Override
    public ReIterator<MemoryKey> iterator(KeyMode mode) {
        return this.stores.get((Object)mode);
    }

    @Override
    public EntryNodeDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void clear() {
    }

    @Override
    public void commitDelta() {
    }

    public String toString() {
        return this.descriptor.getFactType().toString();
    }
}

