/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.evrete.runtime.FactType;
import org.evrete.runtime.evaluation.MemoryAddress;
import org.evrete.util.Mask;

public abstract class NodeDescriptor {
    private final Mask<FactType> factTypeMask = Mask.factTypeMask();
    private final Mask<MemoryAddress> memoryMask = Mask.addressMask();
    private final NodeDescriptor[] sources;
    private final FactType[] factTypes;

    NodeDescriptor(Set<? extends NodeDescriptor> sources) {
        this.sources = new NodeDescriptor[sources.size()];
        HashSet<FactType> types = new HashSet<FactType>();
        int sourceId = 0;
        for (NodeDescriptor nodeDescriptor : sources) {
            types.addAll(Arrays.asList(nodeDescriptor.factTypes));
            this.sources[sourceId++] = nodeDescriptor;
        }
        for (FactType t : this.factTypes = FactType.toArray(types)) {
            this.setMaskBits(t);
        }
    }

    NodeDescriptor(FactType entryType) {
        this.sources = new NodeDescriptor[0];
        this.factTypes = new FactType[]{entryType};
        this.setMaskBits(entryType);
    }

    private void setMaskBits(FactType t) {
        this.factTypeMask.set(t);
        this.memoryMask.set(t.getMemoryAddress());
    }

    public abstract boolean isConditionNode();

    Mask<FactType> getFactTypeMask() {
        return this.factTypeMask;
    }

    public Mask<MemoryAddress> getMemoryMask() {
        return this.memoryMask;
    }

    public FactType[] getTypes() {
        return this.factTypes;
    }

    public final NodeDescriptor[] getSources() {
        return this.sources;
    }
}

