/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.async;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CountedCompleter;
import java.util.function.Function;

public abstract class Completer
extends CountedCompleter<Void> {
    private static final long serialVersionUID = -1753467515874328504L;
    private boolean directInvoke = false;

    Completer(Completer completer) {
        super(completer);
        this.directInvoke = false;
    }

    Completer() {
    }

    public static Completer of(Collection<? extends Runnable> collection) {
        switch (collection.size()) {
            case 0: {
                throw new IllegalArgumentException();
            }
            case 1: {
                return new RunnableCompleter(null, collection.iterator().next());
            }
        }
        return new MultiRunnableCompleter(collection);
    }

    protected abstract void execute();

    boolean isDirectInvoke() {
        return this.directInvoke;
    }

    private void invokeDirect() {
        this.directInvoke = true;
        this.execute();
        this.onCompletion(this);
    }

    @Override
    public final void compute() {
        this.execute();
        this.tryComplete();
    }

    void onCompletion() {
    }

    @Override
    public final void onCompletion(CountedCompleter<?> caller) {
        this.onCompletion();
    }

    void forkNew(Completer completer) {
        if (this.directInvoke) {
            completer.invokeDirect();
        } else {
            this.addToPendingCount(1);
            completer.fork();
        }
    }

    <Z> void tailCall(Collection<Z> collection, Function<Z, Completer> mapper) {
        if (this.directInvoke) {
            for (Z o : collection) {
                mapper.apply(o).invokeDirect();
            }
        } else {
            Iterator<Z> it = collection.iterator();
            while (it.hasNext()) {
                Z item = it.next();
                Completer c = mapper.apply(item);
                this.addToPendingCount(1);
                if (it.hasNext()) {
                    c.fork();
                    continue;
                }
                c.compute();
            }
        }
    }

    static class RunnableCompleter
    extends Completer {
        private static final long serialVersionUID = -3448763603811865456L;
        private final Runnable runnable;

        RunnableCompleter(Completer completer, Runnable runnable) {
            super(completer);
            this.runnable = runnable;
        }

        @Override
        protected void execute() {
            this.runnable.run();
        }
    }

    private static class MultiRunnableCompleter
    extends Completer {
        private static final long serialVersionUID = -243409304205835246L;
        private final Collection<? extends Runnable> collection;

        MultiRunnableCompleter(Collection<? extends Runnable> collection) {
            super((Completer)null);
            assert (collection.size() > 1);
            this.collection = collection;
        }

        @Override
        protected void execute() {
            if (this.isDirectInvoke()) {
                for (Runnable runnable : this.collection) {
                    runnable.run();
                }
            } else {
                Iterator<? extends Runnable> it = this.collection.iterator();
                Runnable runnable = it.next();
                while (it.hasNext()) {
                    this.forkNew(new RunnableCompleter(this, it.next()));
                }
                runnable.run();
            }
        }
    }
}

