/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.evaluation;

import java.util.Arrays;
import java.util.function.Predicate;
import org.evrete.api.Evaluator;
import org.evrete.api.FieldReference;
import org.evrete.api.IntToValue;

public class EvaluatorOfArray
implements Evaluator {
    private final FieldReference[] descriptor;
    private final Predicate<Object[]> predicate;
    private final Object[] sharedValues;

    public EvaluatorOfArray(Predicate<Object[]> predicate, FieldReference ... descriptor) {
        this.descriptor = descriptor;
        this.predicate = predicate;
        this.sharedValues = new Object[descriptor.length];
    }

    @Override
    public FieldReference[] descriptor() {
        return this.descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test(IntToValue values) {
        Object[] objectArray = this.sharedValues;
        synchronized (this.sharedValues) {
            for (int i = 0; i < this.sharedValues.length; ++i) {
                this.sharedValues[i] = values.apply(i);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.predicate.test(this.sharedValues);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluatorOfArray that = (EvaluatorOfArray)o;
        return Arrays.equals(this.descriptor, that.descriptor) && this.predicate.equals(that.predicate);
    }

    public int hashCode() {
        return 31 * this.predicate.hashCode() + Arrays.hashCode(this.descriptor);
    }

    public String toString() {
        return this.predicate.toString();
    }
}

