/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.jsr94;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.rules.RuleExecutionSetNotFoundException;
import javax.rules.admin.RuleExecutionSetRegisterException;
import org.evrete.jsr94.RuleExecutionSetImpl;

class RuleSetRegistrations {
    private final Map<String, RuleExecutionSetImpl> registrations = new ConcurrentHashMap<String, RuleExecutionSetImpl>();

    RuleSetRegistrations() {
    }

    void registerRuleExecutionSet(String s, RuleExecutionSetImpl ruleExecutionSet) throws RuleExecutionSetRegisterException {
        if (s == null) {
            throw new RuleExecutionSetRegisterException("Null registration URI is not allowed");
        }
        this.registrations.put(s, ruleExecutionSet);
    }

    void deregisterRuleExecutionSet(String s) {
        this.registrations.remove(s);
    }

    RuleExecutionSetImpl getChecked(String uri) throws RuleExecutionSetNotFoundException {
        RuleExecutionSetImpl set = this.registrations.get(uri);
        if (set == null) {
            throw new RuleExecutionSetNotFoundException("Ruleset '" + uri + "' not found");
        }
        return set;
    }

    List<String> getKeys() {
        return new ArrayList<String>(this.registrations.keySet());
    }
}

