/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.tx.atomikos.datasource;

import com.atomikos.jdbc.AbstractDataSourceBean;
import com.atomikos.jdbc.AtomikosDataSourceBean;
import com.atomikos.jdbc.nonxa.AtomikosNonXADataSourceBean;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.model.type.resource.datasource.DataSourceConfiguration;
import org.fabric3.api.model.type.resource.datasource.DataSourceType;
import org.fabric3.datasource.spi.DataSourceFactory;
import org.fabric3.datasource.spi.DataSourceFactoryException;
import org.fabric3.datasource.spi.DataSourceRegistry;
import org.fabric3.spi.management.ManagementException;
import org.fabric3.spi.management.ManagementService;
import org.fabric3.tx.atomikos.datasource.DataSourceConfigParser;
import org.fabric3.tx.atomikos.datasource.DataSourceParseException;
import org.fabric3.tx.atomikos.datasource.DataSourceWrapper;
import org.fabric3.tx.atomikos.datasource.DuplicateDataSourceException;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class AtomikosDataSourceFactory
implements DataSourceFactory {
    private DataSourceRegistry registry;
    private ManagementService managementService;
    private List<DataSourceConfiguration> configurations = Collections.emptyList();
    private Map<String, AbstractDataSourceBean> beans;
    private DataSourceConfigParser parser = new DataSourceConfigParser();

    public AtomikosDataSourceFactory(@Reference DataSourceRegistry registry, @Reference ManagementService managementService) {
        this.registry = registry;
        this.managementService = managementService;
    }

    @Property(required=false)
    public void setDataSources(XMLStreamReader reader) throws DataSourceParseException {
        this.configurations = this.parser.parse(reader);
    }

    @Init
    public void init() throws DataSourceFactoryException {
        this.beans = new HashMap<String, AbstractDataSourceBean>();
        for (DataSourceConfiguration configuration : this.configurations) {
            this.create(configuration);
        }
    }

    @Destroy
    public void destroy() throws DataSourceFactoryException {
        for (Map.Entry<String, AbstractDataSourceBean> entry : this.beans.entrySet()) {
            AbstractDataSourceBean bean = entry.getValue();
            this.registry.unregister(entry.getKey());
            this.unRegisterManagement(bean);
            bean.close();
        }
    }

    public void create(DataSourceConfiguration configuration) throws DataSourceFactoryException {
        AtomikosDataSourceBean bean;
        String name = configuration.getName();
        if (this.registry.getDataSource(name) != null) {
            throw new DuplicateDataSourceException("Datasource already registered with name: " + name);
        }
        for (String alias : configuration.getAliases()) {
            if (this.registry.getDataSource(alias) == null) continue;
            throw new DuplicateDataSourceException("Datasource already registered with name: " + name);
        }
        if (DataSourceType.XA == configuration.getType()) {
            bean = new AtomikosDataSourceBean();
            bean.setUniqueResourceName(name);
            Properties properties = configuration.getProperties();
            bean.setXaProperties(properties);
            bean.setXaDataSourceClassName(configuration.getDriverClass());
            this.setBeanProperties(configuration, (AbstractDataSourceBean)bean);
            this.registerManagement((AbstractDataSourceBean)bean, configuration.getAliases());
            this.beans.put(name, (AbstractDataSourceBean)bean);
            this.registry.register(name, (DataSource)bean);
            for (String alias : configuration.getAliases()) {
                this.registry.register(alias, (DataSource)bean);
            }
        } else {
            bean = new AtomikosNonXADataSourceBean();
            bean.setUniqueResourceName(name);
            bean.setDriverClassName(configuration.getDriverClass());
            bean.setUrl(configuration.getUrl());
            bean.setUser(configuration.getUsername());
            bean.setPassword(configuration.getPassword());
            this.setBeanProperties(configuration, (AbstractDataSourceBean)bean);
            this.registerManagement((AbstractDataSourceBean)bean, configuration.getAliases());
            this.beans.put(name, (AbstractDataSourceBean)bean);
            this.registry.register(name, (DataSource)bean);
            for (String alias : configuration.getAliases()) {
                this.registry.register(alias, (DataSource)bean);
            }
        }
    }

    public void remove(DataSourceConfiguration configuration) throws DataSourceFactoryException {
        String name = configuration.getName();
        AbstractDataSourceBean bean = this.beans.remove(name);
        if (bean == null) {
            throw new DataSourceFactoryException("DataSource not registered: " + name);
        }
        for (String alias : configuration.getAliases()) {
            this.registry.unregister(alias);
        }
        this.registry.unregister(name);
        this.unRegisterManagement(bean);
        bean.close();
    }

    private void registerManagement(AbstractDataSourceBean bean, List<String> aliases) throws DataSourceFactoryException {
        String name = bean.getUniqueResourceName();
        try {
            DataSourceWrapper wrapper = new DataSourceWrapper(bean, aliases);
            this.managementService.export(this.encode(name), "datasources", "Configured datasources", (Object)wrapper);
        }
        catch (ManagementException e) {
            throw new DataSourceFactoryException((Throwable)e);
        }
    }

    private void unRegisterManagement(AbstractDataSourceBean bean) throws DataSourceFactoryException {
        try {
            String name = bean.getUniqueResourceName();
            this.managementService.remove(this.encode(name), "datasources");
        }
        catch (ManagementException e) {
            throw new DataSourceFactoryException((Throwable)e);
        }
    }

    private String encode(String name) {
        return "datasources/" + name.toLowerCase();
    }

    private void setBeanProperties(DataSourceConfiguration configuration, AbstractDataSourceBean bean) throws DataSourceFactoryException {
        String query;
        int reapTimeout;
        int poolSize;
        int minPoolSize;
        int maxPoolSize;
        int idleTime;
        int connectionTimeout = configuration.getConnectionTimeout();
        if (connectionTimeout != -1) {
            bean.setBorrowConnectionTimeout(connectionTimeout);
        }
        try {
            int loginTimeout = configuration.getLoginTimeout();
            if (loginTimeout != -1) {
                bean.setLoginTimeout(loginTimeout);
            }
        }
        catch (SQLException e) {
            throw new DataSourceFactoryException((Throwable)e);
        }
        int interval = configuration.getMaintenanceInterval();
        if (interval != -1) {
            bean.setMaintenanceInterval(interval);
        }
        if ((idleTime = configuration.getMaxIdle()) != -1) {
            bean.setMaxIdleTime(idleTime);
        }
        if ((maxPoolSize = configuration.getMaxPoolSize()) != -1) {
            bean.setMaxPoolSize(maxPoolSize);
        }
        if ((minPoolSize = configuration.getMinPoolSize()) != -1) {
            bean.setMinPoolSize(minPoolSize);
        }
        if ((poolSize = configuration.getPoolSize()) != -1) {
            bean.setPoolSize(poolSize);
        }
        if ((reapTimeout = configuration.getReap()) != -1) {
            bean.setReapTimeout(reapTimeout);
        }
        if ((query = configuration.getQuery()) != null) {
            bean.setTestQuery(query);
        }
    }
}

