/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.tx.atomikos.datasource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.model.type.resource.datasource.DataSourceConfiguration;
import org.fabric3.api.model.type.resource.datasource.DataSourceType;
import org.fabric3.tx.atomikos.datasource.DataSourceParseException;

public class DataSourceConfigParser {
    public List<DataSourceConfiguration> parse(XMLStreamReader reader) throws DataSourceParseException {
        ArrayList<DataSourceConfiguration> configurations = new ArrayList<DataSourceConfiguration>();
        try {
            reader.nextTag();
            DataSourceConfiguration configuration = null;
            while (true) {
                switch (reader.next()) {
                    case 1: {
                        String name;
                        if ("datasource".equals(reader.getName().getLocalPart())) {
                            name = this.readMandatoryAttribute("name", reader);
                            DataSourceType dataSourceType = this.parseType(reader);
                            String driver = this.readMandatoryAttribute("driver", reader);
                            configuration = new DataSourceConfiguration(name, driver, dataSourceType);
                            List<String> aliases = this.readAliases(reader);
                            configuration.setAliases(aliases);
                            String url = reader.getAttributeValue(null, "url");
                            configuration.setUrl(url);
                            String username = reader.getAttributeValue(null, "username");
                            configuration.setUsername(username);
                            String password = reader.getAttributeValue(null, "password");
                            configuration.setPassword(password);
                            break;
                        }
                        if (configuration == null) break;
                        name = reader.getName().getLocalPart();
                        String value = reader.getElementText();
                        if ("maxPoolSize".equals(name)) {
                            configuration.setMaxPoolSize(this.parseInt(value, "maxPoolSize"));
                            break;
                        }
                        if ("minPoolSize".equals(name)) {
                            configuration.setMinPoolSize(this.parseInt(value, "minPoolSize"));
                            break;
                        }
                        if ("connectionTimeout".equals(name)) {
                            configuration.setConnectionTimeout(this.parseInt(value, "connectionTimeout"));
                            break;
                        }
                        if ("loginTimeout".equals(name)) {
                            configuration.setLoginTimeout(this.parseInt(value, "loginTimeout"));
                            break;
                        }
                        if ("maintenanceInterval".equals(name)) {
                            configuration.setMaintenanceInterval(this.parseInt(value, "maintenanceInterval"));
                            break;
                        }
                        if ("maxIdle".equals(name)) {
                            configuration.setMaxIdle(this.parseInt(value, "maxIdle"));
                            break;
                        }
                        if ("poolSize".equals(name)) {
                            configuration.setPoolSize(this.parseInt(value, "poolSize"));
                            break;
                        }
                        if ("reap".equals(name)) {
                            configuration.setReap(this.parseInt(value, "reap"));
                            break;
                        }
                        if ("query".equals(name)) {
                            configuration.setQuery(value);
                            break;
                        }
                        configuration.setProperty(name, value);
                        break;
                    }
                    case 2: {
                        if ("datasource".equals(reader.getName().getLocalPart())) {
                            configurations.add(configuration);
                            break;
                        }
                    }
                    case 8: {
                        return configurations;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new DataSourceParseException(e);
        }
    }

    private List<String> readAliases(XMLStreamReader reader) {
        String aliasesAttr = reader.getAttributeValue(null, "aliases");
        if (aliasesAttr == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(aliasesAttr.split(","));
    }

    private DataSourceType parseType(XMLStreamReader reader) throws DataSourceParseException {
        DataSourceType dataSourceType;
        String type = this.readMandatoryAttribute("type", reader);
        if (type == null) {
            dataSourceType = DataSourceType.NON_XA;
        } else {
            try {
                dataSourceType = DataSourceType.valueOf((String)type.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new DataSourceParseException("Datasource type must be either xa or non_xa");
            }
        }
        return dataSourceType;
    }

    private int parseInt(String value, String name) throws DataSourceParseException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new DataSourceParseException("Invalid value for " + name, e);
        }
    }

    private String readMandatoryAttribute(String name, XMLStreamReader reader) throws DataSourceParseException {
        String val = reader.getAttributeValue(null, name);
        if (val == null) {
            Location location = reader.getLocation();
            if (location == null) {
                throw new DataSourceParseException("Datasource " + name + " not specified in system configuration");
            }
            int line = location.getLineNumber();
            int col = location.getColumnNumber();
            throw new DataSourceParseException("Datasource " + name + " not configured [" + line + "," + col + "]");
        }
        return val;
    }
}

