/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.tx.atomikos.datasource;

import com.atomikos.jdbc.AbstractDataSourceBean;
import com.atomikos.jdbc.AtomikosSQLException;
import java.sql.SQLException;
import java.util.List;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;

@Management
public class DataSourceWrapper {
    private AbstractDataSourceBean delegate;
    private List<String> aliases;

    public DataSourceWrapper(AbstractDataSourceBean delegate, List<String> aliases) {
        this.delegate = delegate;
        this.aliases = aliases;
    }

    @ManagementOperation(description="The aliases this datasource is registered under")
    public List<String> getAliases() {
        return this.aliases;
    }

    @ManagementOperation(description="The aliases this datasource is registered under")
    public void setAliases(List<String> aliases) {
        throw new UnsupportedOperationException("Aliases are immutable");
    }

    @ManagementOperation(description="The minimum connection pool size")
    public int getMinPoolSize() {
        return this.delegate.getMinPoolSize();
    }

    @ManagementOperation(description="The minimum connection pool size")
    public void setMinPoolSize(int minPoolSize) {
        this.delegate.setMinPoolSize(minPoolSize);
    }

    @ManagementOperation(description="The maximum connection pool size")
    public int getMaxPoolSize() {
        return this.delegate.getMaxPoolSize();
    }

    @ManagementOperation(description="The maximum connection pool size")
    public void setMaxPoolSize(int maxPoolSize) {
        this.delegate.setMaxPoolSize(maxPoolSize);
    }

    @ManagementOperation(description="Sets the connection pool minimum and maximum size")
    public void setPoolSize(int poolSize) {
        this.delegate.setMinPoolSize(poolSize);
        this.delegate.setMaxPoolSize(poolSize);
    }

    @ManagementOperation(description="The maximum amount of time in seconds the pool will block waiting for a connection to become available in the pool when it is empty")
    public int getBorrowConnectionTimeout() {
        return this.delegate.getBorrowConnectionTimeout();
    }

    @ManagementOperation(description="The maximum amount of time in seconds the pool will block waiting for a connection to become available in the pool when it is empty")
    public void setBorrowConnectionTimeout(int borrowConnectionTimeout) {
        this.delegate.setBorrowConnectionTimeout(borrowConnectionTimeout);
    }

    @ManagementOperation(description="The amount of time in seconds the connection pool will allow a connection to be borrowed before claiming it back")
    public int getReapTimeout() {
        return this.delegate.getReapTimeout();
    }

    @ManagementOperation(description="The amount of time in seconds the connection pool will allow a connection to be borrowed before claiming it back")
    public void setReapTimeout(int reapTimeout) {
        this.delegate.setReapTimeout(reapTimeout);
    }

    @ManagementOperation(description="The maintenance interval for the pool maintenance thread")
    public void setMaintenanceInterval(int maintenanceInterval) {
        this.delegate.setMaintenanceInterval(maintenanceInterval);
    }

    @ManagementOperation(description="The maintenance interval for the pool maintenance thread")
    public int getMaintenanceInterval() {
        return this.delegate.getMaintenanceInterval();
    }

    @ManagementOperation(description="The maximum amount of time in seconds a connection can stay in the pool before being eligible for being closed during pool shrinking")
    public int getMaxIdleTime() {
        return this.delegate.getMaxIdleTime();
    }

    @ManagementOperation(description="The maximum amount of time in seconds a connection can stay in the pool before being eligible for being closed during pool shrinking")
    public void setMaxIdleTime(int maxIdleTime) {
        this.delegate.setMaxIdleTime(maxIdleTime);
    }

    @ManagementOperation(description="The SQL query used to test a connection before returning it")
    public String getTestQuery() {
        return this.delegate.getTestQuery();
    }

    @ManagementOperation(description="The SQL query used to test a connection before returning it")
    public void setTestQuery(String testQuery) {
        this.delegate.setTestQuery(testQuery);
    }

    @ManagementOperation(description="The approximate number of available connections in the pool")
    public int poolAvailableSize() throws AtomikosSQLException {
        this.delegate.init();
        return this.delegate.poolAvailableSize();
    }

    @ManagementOperation(description="The total number of available connections in the pool")
    public int poolTotalSize() throws AtomikosSQLException {
        this.delegate.init();
        return this.delegate.poolTotalSize();
    }

    @ManagementOperation(description="The login timeout")
    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    @ManagementOperation(description="The login timeout")
    public void setLoginTimeout(int seconds) throws SQLException {
        this.delegate.setLoginTimeout(seconds);
    }
}

