/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.tx.atomikos.tm;

import com.atomikos.icatch.config.UserTransactionService;
import com.atomikos.icatch.config.UserTransactionServiceImp;
import com.atomikos.icatch.jta.TransactionManagerImp;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.spi.runtime.event.EventService;
import org.fabric3.spi.runtime.event.Fabric3EventListener;
import org.fabric3.spi.runtime.event.RuntimeRecover;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;

@Service(value={TransactionManager.class})
public class AtomikosTransactionManager
implements TransactionManager,
Fabric3EventListener<RuntimeRecover> {
    private static final String TM_NAME = "com.atomikos.icatch.tm_unique_name";
    private static final String ATOMIKOS_NO_FILE = "com.atomikos.icatch.no_file";
    private static final String OUTPUT_DIR_PROPERTY_NAME = "com.atomikos.icatch.output_dir";
    private static final String LOG_BASE_DIR_PROPERTY_NAME = "com.atomikos.icatch.log_base_dir";
    private static final String FACTORY_KEY = "com.atomikos.icatch.service";
    private static final String FACTORY_VALUE = "com.atomikos.icatch.standalone.UserTransactionServiceFactory";
    private static final String THREADED2PC = "com.atomikos.icatch.threaded_2pc";
    private static final String ENABLE_LOGGING = "com.atomikos.icatch.enable_logging";
    private static final String CHECKPOINT_INTERVAL = "com.atomikos.icatch.checkpoint_interval";
    private EventService eventService;
    private HostInfo info;
    private TransactionManagerImp tm;
    private UserTransactionService uts;
    private Properties properties = new Properties();
    private int timeout = -1;
    private boolean singleThreaded2PC;
    private boolean enableLogging = true;
    private long checkPointInterval = -1L;

    public AtomikosTransactionManager(@Reference EventService eventService, @Reference HostInfo info) {
        this.eventService = eventService;
        this.info = info;
    }

    @Property(required=false)
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Property(required=false)
    public void setProperties(Map<String, String> properties) {
        this.properties.putAll(properties);
    }

    @Property(required=false)
    public void setSingleThreaded2PC(boolean singleThreaded2PC) {
        this.singleThreaded2PC = singleThreaded2PC;
    }

    @Property(required=false)
    public void setEnableLogging(boolean enableLogging) {
        this.enableLogging = enableLogging;
    }

    @Property(required=false)
    public void setCheckPointInterval(long checkPointInterval) {
        this.checkPointInterval = checkPointInterval;
    }

    @Init
    public void init() throws IOException {
        String name;
        this.eventService.subscribe(RuntimeRecover.class, (Fabric3EventListener)this);
        System.setProperty(ATOMIKOS_NO_FILE, "true");
        System.setProperty(FACTORY_KEY, FACTORY_VALUE);
        File dataDir = this.info.getDataDir();
        File trxDir = new File(dataDir, "transactions");
        if (!trxDir.exists()) {
            trxDir.mkdirs();
        }
        if ((name = this.info.getRuntimeName().replace(":", "_")).getBytes().length + 16 > 64) {
            name = new String(Arrays.copyOfRange(name.getBytes(), 0, 48));
        }
        this.properties.setProperty(TM_NAME, name);
        String path = trxDir.getCanonicalPath();
        this.properties.setProperty(OUTPUT_DIR_PROPERTY_NAME, path);
        this.properties.setProperty(LOG_BASE_DIR_PROPERTY_NAME, path);
        this.properties.setProperty(THREADED2PC, Boolean.toString(this.singleThreaded2PC));
        this.properties.setProperty(ENABLE_LOGGING, Boolean.toString(this.enableLogging));
        if (this.checkPointInterval != -1L) {
            this.properties.setProperty(CHECKPOINT_INTERVAL, Long.toString(this.checkPointInterval));
        }
    }

    @Destroy
    public void destroy() {
        if (this.uts != null) {
            this.uts.shutdown(false);
            this.uts = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(RuntimeRecover event) {
        Class<TransactionManagerImp> clazz = TransactionManagerImp.class;
        synchronized (TransactionManagerImp.class) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.tm = (TransactionManagerImp)TransactionManagerImp.getTransactionManager();
                if (this.tm == null) {
                    this.uts = new UserTransactionServiceImp(this.properties);
                    this.uts.init(this.properties);
                    this.tm = (TransactionManagerImp)TransactionManagerImp.getTransactionManager();
                }
                if (this.timeout != -1) {
                    try {
                        this.tm.setTransactionTimeout(this.timeout);
                    }
                    catch (SystemException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        this.tm.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.tm.commit();
    }

    public int getStatus() throws SystemException {
        return this.tm.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.tm.getTransaction();
    }

    public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.tm.resume(tx);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.tm.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.tm.setRollbackOnly();
    }

    public void setTransactionTimeout(int secs) throws SystemException {
        this.tm.setTransactionTimeout(secs);
    }

    public Transaction suspend() throws SystemException {
        return this.tm.suspend();
    }
}

