/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.runtime.weblogic.federation;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fabric3.runtime.weblogic.cluster.ChannelException;
import org.fabric3.runtime.weblogic.cluster.RuntimeChannel;
import org.fabric3.runtime.weblogic.federation.WebLogicTopologyMonitor;
import org.fabric3.spi.classloader.SerializationService;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.command.Command;
import org.fabric3.spi.container.command.Response;
import org.fabric3.spi.container.command.ResponseCommand;
import org.fabric3.spi.container.executor.CommandExecutorRegistry;
import org.fabric3.spi.federation.topology.MessageReceiver;

public class RuntimeChannelImpl
implements RuntimeChannel {
    private String runtimeName;
    private CommandExecutorRegistry executorRegistry;
    private SerializationService serializationService;
    private WebLogicTopologyMonitor monitor;
    private MessageReceiver messageReceiver;
    private AtomicBoolean active;

    public RuntimeChannelImpl(String runtimeName, CommandExecutorRegistry executorRegistry, SerializationService serializationService, WebLogicTopologyMonitor monitor) {
        this(runtimeName, executorRegistry, serializationService, null, monitor);
    }

    public RuntimeChannelImpl(String runtimeName, CommandExecutorRegistry executorRegistry, SerializationService serializationService, MessageReceiver messageReceiver, WebLogicTopologyMonitor monitor) {
        this.runtimeName = runtimeName;
        this.executorRegistry = executorRegistry;
        this.serializationService = serializationService;
        this.messageReceiver = messageReceiver;
        this.monitor = monitor;
        this.active = new AtomicBoolean(true);
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public byte[] sendSynchronous(byte[] payload) throws RemoteException, ChannelException {
        if (!this.active.get()) {
            throw new ChannelException("Channel inactive");
        }
        try {
            ResponseCommand command = (ResponseCommand)this.serializationService.deserialize(ResponseCommand.class, payload);
            this.executorRegistry.execute((Command)command);
            Response response = command.getResponse();
            return this.serializationService.serialize((Serializable)response);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ChannelException((Throwable)e);
        }
        catch (ContainerException e) {
            this.monitor.error(e);
            throw new ChannelException(e.getMessage());
        }
    }

    public void send(byte[] payload) throws RemoteException, ChannelException {
        if (!this.active.get()) {
            throw new ChannelException("Channel inactive");
        }
        try {
            Command command = (Command)this.serializationService.deserialize(Command.class, payload);
            this.executorRegistry.execute(command);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ChannelException((Throwable)e);
        }
        catch (ContainerException e) {
            this.monitor.error(e);
            throw new ChannelException(e.getMessage());
        }
    }

    public void publish(byte[] payload) throws RemoteException, ChannelException {
        if (!this.active.get()) {
            return;
        }
        if (this.messageReceiver == null) {
            throw new ChannelException("Channel not configured with a message receiver");
        }
        try {
            Object message = this.serializationService.deserialize(Object.class, payload);
            this.messageReceiver.onMessage(message);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public void shutdown() {
        this.active.set(false);
    }

    public boolean isActive() {
        return this.active.get();
    }
}

