/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.runtime.weblogic.federation;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.event.EventContext;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.runtime.weblogic.cluster.ChannelException;
import org.fabric3.runtime.weblogic.cluster.RuntimeChannel;
import org.fabric3.runtime.weblogic.federation.JmxHelper;
import org.fabric3.runtime.weblogic.federation.JndiHelper;
import org.fabric3.runtime.weblogic.federation.RuntimeChannelImpl;
import org.fabric3.runtime.weblogic.federation.WebLogicTopologyMonitor;
import org.fabric3.spi.classloader.SerializationService;
import org.fabric3.spi.container.command.Command;
import org.fabric3.spi.container.command.Response;
import org.fabric3.spi.container.command.ResponseCommand;
import org.fabric3.spi.container.executor.CommandExecutorRegistry;
import org.fabric3.spi.federation.topology.ControllerTopologyService;
import org.fabric3.spi.federation.topology.MessageException;
import org.fabric3.spi.federation.topology.MessageReceiver;
import org.fabric3.spi.federation.topology.RuntimeInstance;
import org.fabric3.spi.federation.topology.TopologyListener;
import org.fabric3.spi.federation.topology.Zone;
import org.fabric3.spi.federation.topology.ZoneChannelException;
import org.fabric3.spi.runtime.event.EventService;
import org.fabric3.spi.runtime.event.Fabric3EventListener;
import org.fabric3.spi.runtime.event.JoinDomain;
import org.fabric3.spi.runtime.event.RuntimeStop;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;

@Service(value={ControllerTopologyService.class})
@EagerInit
public class WebLogicControllerTopologyService
implements ControllerTopologyService {
    private static final String RUNTIME_NAME = "controller";
    private CommandExecutorRegistry executorRegistry;
    private EventService eventService;
    private SerializationService serializationService;
    private WebLogicTopologyMonitor monitor;
    private InitialContext rootContext;
    private EventContext participantContext;
    private RuntimeChannelImpl controllerChannel;
    private JmxHelper jmxHelper;
    private String domainName;
    private Set<String> openChannels = new HashSet<String>();

    public WebLogicControllerTopologyService(@Reference CommandExecutorRegistry executorRegistry, @Reference EventService eventService, @Reference SerializationService serializationService, @Reference JmxHelper jmxHelper, @Monitor WebLogicTopologyMonitor monitor) {
        this.executorRegistry = executorRegistry;
        this.eventService = eventService;
        this.serializationService = serializationService;
        this.jmxHelper = jmxHelper;
        this.monitor = monitor;
    }

    @Init
    public void init() throws NamingException, JMException {
        this.domainName = this.jmxHelper.getRuntimeJmxAttribute(String.class, "DomainConfiguration/Name");
        this.eventService.subscribe(JoinDomain.class, (Fabric3EventListener)new JoinDomainListener());
        this.eventService.subscribe(RuntimeStop.class, (Fabric3EventListener)new RuntimeStopListener());
    }

    public Set<Zone> getZones() {
        List<RuntimeInstance> runtimes = this.getRuntimes();
        if (runtimes.isEmpty()) {
            return Collections.emptySet();
        }
        Zone zone = new Zone(this.domainName, runtimes);
        return Collections.singleton(zone);
    }

    public List<RuntimeInstance> getRuntimes() {
        ArrayList<RuntimeInstance> instances = new ArrayList<RuntimeInstance>();
        try {
            NamingEnumeration<Binding> list = this.rootContext.listBindings("Fabric3Participants");
            while (list.hasMore()) {
                Binding binding = list.next();
                RuntimeChannel channel = (RuntimeChannel)binding.getObject();
                String RUNTIME_NAME = channel.getRuntimeName();
                RuntimeInstance runtimeInstance = new RuntimeInstance(RUNTIME_NAME);
                instances.add(runtimeInstance);
            }
        }
        catch (RemoteException | NamingException e) {
            this.monitor.error(e);
        }
        return instances;
    }

    public void broadcast(Command command) throws MessageException {
        try {
            byte[] payload = this.serializationService.serialize((Serializable)command);
            NamingEnumeration<Binding> list = this.rootContext.listBindings("Fabric3Participants");
            while (list.hasMore()) {
                Binding binding = list.next();
                RuntimeChannel channel = (RuntimeChannel)binding.getObject();
                if (!channel.isActive()) continue;
                channel.send(payload);
            }
        }
        catch (IOException | NamingException | ChannelException e) {
            throw new MessageException(e);
        }
    }

    public void broadcast(String zoneName, Command command) throws MessageException {
        List<RuntimeChannel> channels = this.getChannels();
        try {
            byte[] payload = this.serializationService.serialize((Serializable)command);
            for (RuntimeChannel channel : channels) {
                if (!channel.isActive()) continue;
                channel.send(payload);
            }
        }
        catch (IOException | ChannelException e) {
            throw new MessageException(e);
        }
    }

    public List<Response> sendSynchronousToZone(String zoneName, ResponseCommand command, boolean failFast, long timeout) throws MessageException {
        byte[] payload;
        List<RuntimeChannel> channels = this.getChannels();
        if (channels.isEmpty()) {
            throw new MessageException("No managed servers found to deploy to");
        }
        ArrayList<Response> responses = new ArrayList<Response>();
        try {
            payload = this.serializationService.serialize((Serializable)command);
        }
        catch (IOException e) {
            throw new MessageException((Throwable)e);
        }
        for (RuntimeChannel channel : channels) {
            try {
                if (!channel.isActive()) continue;
                byte[] responsePayload = channel.sendSynchronous(payload);
                Response response = (Response)this.serializationService.deserialize(Response.class, responsePayload);
                responses.add(response);
            }
            catch (IOException | ClassNotFoundException | ChannelException e) {
                throw new MessageException(e);
            }
        }
        return responses;
    }

    public boolean isChannelOpen(String name) {
        return this.openChannels.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void openChannel(String name, String configuration, MessageReceiver receiver, TopologyListener listener) throws ZoneChannelException {
        if (this.isChannelOpen(name)) {
            throw new ZoneChannelException("Channel already open: " + name);
        }
        Context rootContext = null;
        Context dynamicChannelContext = null;
        RuntimeChannelImpl channel = new RuntimeChannelImpl(RUNTIME_NAME, this.executorRegistry, this.serializationService, receiver, this.monitor);
        try {
            dynamicChannelContext = JndiHelper.getContext("Fabric3DynamicChannels", rootContext);
            dynamicChannelContext.bind(name + ":" + RUNTIME_NAME, (Object)channel);
            this.openChannels.add(name);
        }
        catch (NameAlreadyBoundException e) {
            try {
                dynamicChannelContext.rebind(name + ":" + RUNTIME_NAME, (Object)channel);
            }
            catch (NamingException ex) {
                this.monitor.errorMessage("Error binding channel: " + name);
                this.monitor.errorDetail(e);
            }
            JndiHelper.close(rootContext, dynamicChannelContext);
        }
        catch (NamingException e2) {
            this.monitor.errorMessage("Error binding channel: " + name);
            this.monitor.errorDetail(e2);
            {
                catch (Throwable throwable) {
                    JndiHelper.close(rootContext, dynamicChannelContext);
                    throw throwable;
                }
            }
            JndiHelper.close(rootContext, dynamicChannelContext);
        }
        JndiHelper.close(rootContext, dynamicChannelContext);
    }

    /*
     * Loose catch block
     */
    public void closeChannel(String name) throws ZoneChannelException {
        Context rootContext = null;
        Context dynamicChannelContext = null;
        try {
            dynamicChannelContext = JndiHelper.getContext("Fabric3DynamicChannels", rootContext);
            dynamicChannelContext.unbind(name + ":" + RUNTIME_NAME);
            this.openChannels.remove(name);
        }
        catch (CommunicationException e) {
            JndiHelper.close(rootContext, dynamicChannelContext);
        }
        catch (NamingException e2) {
            throw new ZoneChannelException((Throwable)e2);
            {
                catch (Throwable throwable) {
                    JndiHelper.close(rootContext, dynamicChannelContext);
                    throw throwable;
                }
            }
        }
        JndiHelper.close(rootContext, dynamicChannelContext);
    }

    public void sendAsynchronous(String name, Serializable message) throws MessageException {
        Context rootContext = null;
        try {
            byte[] payload = this.serializationService.serialize(message);
            NamingEnumeration<Binding> enumeration = rootContext.listBindings("Fabric3DynamicChannels");
            while (enumeration.hasMoreElements()) {
                Binding binding = enumeration.next();
                if (!RuntimeChannel.class.getName().equals(binding.getClassName())) continue;
                RuntimeChannel channel = (RuntimeChannel)binding.getObject();
                if (!binding.getName().startsWith(name + ":") || channel.getRuntimeName().equals(RUNTIME_NAME)) continue;
                channel.publish(payload);
            }
        }
        catch (IOException | NamingException | ChannelException e) {
            try {
                throw new MessageException(e);
            }
            catch (Throwable throwable) {
                JndiHelper.close(rootContext);
                throw throwable;
            }
        }
        JndiHelper.close(rootContext);
    }

    private List<RuntimeChannel> getChannels() throws MessageException {
        try {
            ArrayList<RuntimeChannel> channels = new ArrayList<RuntimeChannel>();
            NamingEnumeration<Binding> list = this.rootContext.listBindings("Fabric3Participants");
            while (list.hasMore()) {
                Binding binding = list.next();
                RuntimeChannel channel = (RuntimeChannel)binding.getObject();
                channels.add(channel);
            }
            return channels;
        }
        catch (NameNotFoundException e) {
            this.monitor.noManagedServers();
            return Collections.emptyList();
        }
        catch (NamingException e) {
            throw new MessageException((Throwable)e);
        }
    }

    private void bindController() {
        try {
            this.controllerChannel = new RuntimeChannelImpl(RUNTIME_NAME, this.executorRegistry, this.serializationService, this.monitor);
            this.rootContext = new InitialContext();
            Context controllerContext = JndiHelper.getContext("Fabric3ControllerContext", this.rootContext);
            try {
                controllerContext.bind("Fabric3ControllerChannel", (Object)this.controllerChannel);
            }
            catch (NameAlreadyBoundException e) {
                controllerContext.rebind("Fabric3ControllerChannel", (Object)this.controllerChannel);
            }
            Context ctx = JndiHelper.getContext("Fabric3Participants", this.rootContext);
            assert (ctx instanceof EventContext);
            this.participantContext = (EventContext)ctx;
        }
        catch (NamingException e) {
            this.monitor.errorMessage("Error initializing domain topology service", e);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private class RuntimeStopListener
    implements Fabric3EventListener<RuntimeStop> {
        private RuntimeStopListener() {
        }

        public void onEvent(RuntimeStop event) {
            if (WebLogicControllerTopologyService.this.controllerChannel != null) {
                WebLogicControllerTopologyService.this.controllerChannel.shutdown();
            }
            if (WebLogicControllerTopologyService.this.rootContext != null) {
                try {
                    WebLogicControllerTopologyService.this.rootContext.unbind("Fabric3ControllerChannel");
                    WebLogicControllerTopologyService.this.rootContext.close();
                }
                catch (NamingException e) {
                    WebLogicControllerTopologyService.this.monitor.error(e);
                }
            }
            if (WebLogicControllerTopologyService.this.participantContext != null) {
                try {
                    WebLogicControllerTopologyService.this.participantContext.close();
                }
                catch (NamingException e) {
                    WebLogicControllerTopologyService.this.monitor.error(e);
                }
            }
        }
    }

    private class JoinDomainListener
    implements Fabric3EventListener<JoinDomain> {
        private JoinDomainListener() {
        }

        public void onEvent(JoinDomain event) {
            WebLogicControllerTopologyService.this.bindController();
        }
    }
}

