/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.client.grpc.cli.cmd;

import java.util.ArrayList;
import java.util.UUID;
import org.factcast.client.grpc.cli.cmd.Catchup;
import org.factcast.client.grpc.cli.util.ConsoleFactObserver;
import org.factcast.client.grpc.cli.util.Options;
import org.factcast.core.FactCast;
import org.factcast.core.spec.FactSpec;
import org.factcast.core.store.FactStore;
import org.factcast.core.subscription.SubscriptionRequest;
import org.factcast.core.subscription.SubscriptionRequestTO;
import org.factcast.core.subscription.observer.FactObserver;
import org.factcast.core.subscription.observer.GenericObserver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class CatchupTest {
    @Mock
    FactStore fs;
    FactCast fc;

    CatchupTest() {
    }

    @Test
    void testCatchup() {
        String ns = "foo";
        UUID startId = new UUID(0L, 1L);
        Catchup cmd = new Catchup(ns, startId);
        this.fc = (FactCast)Mockito.spy((Object)FactCast.from((FactStore)this.fs));
        Options opt = new Options();
        Mockito.when((Object)this.fs.subscribe((SubscriptionRequestTO)Mockito.any(), (FactObserver)Mockito.any(ConsoleFactObserver.class))).thenAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            GenericObserver o = (GenericObserver)args[1];
            o.onCatchup();
            o.onComplete();
            SubscriptionRequest r = (SubscriptionRequest)args[0];
            ArrayList specs = new ArrayList(r.specs());
            Assertions.assertEquals((Object)startId, r.startingAfter().orElse(null));
            Assertions.assertEquals((Object)ns, (Object)((FactSpec)specs.iterator().next()).ns());
            return null;
        });
        cmd.runWith(this.fc, opt);
        ((FactCast)Mockito.verify((Object)this.fc)).subscribeEphemeral((SubscriptionRequest)Mockito.any(SubscriptionRequest.class), (FactObserver)Mockito.any(ConsoleFactObserver.class));
    }
}

