/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.client.grpc.cli.util;

import java.util.UUID;
import org.factcast.client.grpc.cli.util.FactRenderer;
import org.factcast.client.grpc.cli.util.Options;
import org.factcast.core.Fact;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FactRendererTest {
    Fact f = Fact.builder().id(new UUID(0L, 0L)).ns("ns").aggId(new UUID(0L, 1L)).meta("foo", "bar").type("type").build("{\"some\":\"json\"}");

    @Test
    void testRender() throws Exception {
        FactRenderer uut = new FactRenderer(new Options());
        Assertions.assertEquals((Object)"Fact: id=00000000-0000-0000-0000-000000000000\n\theader: {\"id\":\"00000000-0000-0000-0000-000000000000\",\"ns\":\"ns\",\"type\":\"type\",\"version\":0,\"aggIds\":[\"00000000-0000-0000-0000-000000000001\"],\"meta\":{\"foo\":\"bar\"}}\n\tpayload: {\"some\":\"json\"}\n\n", (Object)uut.render(this.f));
    }

    @Test
    void testRenderPretty() throws Exception {
        Options options = new Options();
        options.pretty = true;
        FactRenderer uut = new FactRenderer(options);
        Assertions.assertEquals((Object)"Fact: id=00000000-0000-0000-0000-000000000000\n\theader: {\n\t\t  \"id\" : \"00000000-0000-0000-0000-000000000000\",\n\t\t  \"ns\" : \"ns\",\n\t\t  \"type\" : \"type\",\n\t\t  \"version\" : 0,\n\t\t  \"aggIds\" : [ \"00000000-0000-0000-0000-000000000001\" ],\n\t\t  \"meta\" : {\n\t\t    \"foo\" : \"bar\"\n\t\t  }\n\t\t}\n\tpayload: {\n\t\t  \"some\" : \"json\"\n\t\t}\n\n", (Object)uut.render(this.f));
    }
}

