/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.server.grpc;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ServerCallStreamObserver;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.factcast.server.grpc.BlockingStreamObserver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class BlockingStreamObserverTest {
    @Mock
    private ServerCallStreamObserver<Object> delegate;
    private BlockingStreamObserver<Object> uut;

    @BeforeEach
    void setUp() {
        this.uut = new BlockingStreamObserver("foo", this.delegate, 1);
    }

    @Test
    void testOnCompleted() {
        ((ServerCallStreamObserver)Mockito.verify(this.delegate, (VerificationMode)Mockito.never())).onCompleted();
        this.uut.onCompleted();
        ((ServerCallStreamObserver)Mockito.verify(this.delegate)).onCompleted();
    }

    @Test
    void testNullContract() {
        BlockingStreamObserverTest.expectNPE(() -> new BlockingStreamObserver(null, (ServerCallStreamObserver)Mockito.mock(ServerCallStreamObserver.class), 1));
        BlockingStreamObserverTest.expectNPE(() -> new BlockingStreamObserver(null, null, 1));
        BlockingStreamObserverTest.expectNPE(() -> new BlockingStreamObserver("oink", null, 1));
    }

    @Test
    void testOnErrorDelegates() {
        ((ServerCallStreamObserver)Mockito.verify(this.delegate, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any());
        this.uut.onError((Throwable)new Exception());
        ((ServerCallStreamObserver)Mockito.verify(this.delegate)).onError((Throwable)Mockito.any());
    }

    @Test
    void testOnErrorDelegatesSreWithoutTransforming() {
        StatusRuntimeException sre = new StatusRuntimeException(Status.NOT_FOUND);
        ((ServerCallStreamObserver)Mockito.verify(this.delegate, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any());
        this.uut.onError((Throwable)sre);
        ((ServerCallStreamObserver)Mockito.verify(this.delegate)).onError((Throwable)sre);
    }

    @Test
    void testOnErrorTranslatesToSre() {
        IOException ioException = new IOException("i want to be wrapped");
        ((ServerCallStreamObserver)Mockito.verify(this.delegate, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any());
        this.uut.onError((Throwable)ioException);
        ((ServerCallStreamObserver)Mockito.verify(this.delegate)).onError((Throwable)Mockito.any(StatusRuntimeException.class));
    }

    @Test
    void testOnNextWhenReady() {
        Mockito.when((Object)this.delegate.isReady()).thenReturn((Object)true);
        this.uut.onNext(new Object());
        ((ServerCallStreamObserver)Mockito.verify(this.delegate)).onNext(Mockito.any());
    }

    @Test
    void testOnNextNotYetReady() throws Exception {
        AtomicBoolean ready = new AtomicBoolean(false);
        Mockito.when((Object)this.delegate.isReady()).thenAnswer(i -> ready.get());
        CompletableFuture<Void> onNextCall = CompletableFuture.runAsync(() -> this.uut.onNext(new Object()));
        Thread.sleep(30L);
        Assertions.assertFalse((boolean)onNextCall.isDone());
        ready.set(true);
        this.uut.wakeup();
        Thread.sleep(30L);
        Assertions.assertTrue((boolean)onNextCall.isDone());
        ((ServerCallStreamObserver)Mockito.verify(this.delegate)).onNext(Mockito.any());
    }

    @Test
    void testOnNextNotReadyThenCancelled() throws Exception {
        AtomicBoolean ready = new AtomicBoolean(false);
        AtomicBoolean cancelled = new AtomicBoolean(false);
        Mockito.when((Object)this.delegate.isReady()).thenAnswer(i -> ready.get());
        Mockito.when((Object)this.delegate.isCancelled()).thenAnswer(i -> cancelled.get());
        CompletableFuture<Void> onNextCall = CompletableFuture.runAsync(() -> this.uut.onNext(new Object()));
        Thread.sleep(100L);
        Assertions.assertFalse((boolean)onNextCall.isDone());
        cancelled.set(true);
        this.uut.wakeup();
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)onNextCall.isDone());
        ((ServerCallStreamObserver)Mockito.verify(this.delegate, (VerificationMode)Mockito.never())).onNext(Mockito.any());
    }

    public static void expectNPE(Runnable r) {
        BlockingStreamObserverTest.expect(r, NullPointerException.class, IllegalArgumentException.class);
    }

    @SafeVarargs
    public static void expect(Runnable r, Class<? extends Throwable> ... ex) {
        block2: {
            try {
                r.run();
                Assertions.fail((String)("expected " + Arrays.toString(ex)));
            }
            catch (Throwable actual) {
                boolean matches = Arrays.stream(ex).anyMatch(e -> e.isInstance(actual));
                if (matches) break block2;
                Assertions.fail((String)("Wrong exception, expected " + Arrays.toString(ex) + " but got " + actual));
            }
        }
    }
}

