/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.server.grpc;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;
import org.assertj.core.api.Assertions;
import org.factcast.core.Fact;
import org.factcast.core.snap.Snapshot;
import org.factcast.core.snap.SnapshotId;
import org.factcast.core.spec.FactSpec;
import org.factcast.core.store.FactStore;
import org.factcast.core.store.StateToken;
import org.factcast.core.subscription.SubscriptionRequest;
import org.factcast.core.subscription.SubscriptionRequestTO;
import org.factcast.core.subscription.TransformationException;
import org.factcast.core.subscription.observer.FactObserver;
import org.factcast.core.subscription.observer.FastForwardTarget;
import org.factcast.grpc.api.Capabilities;
import org.factcast.grpc.api.ConditionalPublishRequest;
import org.factcast.grpc.api.StateForRequest;
import org.factcast.grpc.api.conv.ProtoConverter;
import org.factcast.grpc.api.gen.FactStoreProto;
import org.factcast.server.grpc.FactStoreGrpcService;
import org.factcast.server.grpc.GrpcLimitProperties;
import org.factcast.server.grpc.GrpcRequestMetadata;
import org.factcast.server.grpc.auth.FactCastAccount;
import org.factcast.server.grpc.auth.FactCastUser;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.security.access.intercept.RunAsUserToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

@ExtendWith(value={MockitoExtension.class})
public class FactStoreGrpcServiceTest {
    @Mock
    private FactStore backend;
    @Mock
    private GrpcRequestMetadata meta;
    @Mock
    private FastForwardTarget ffwdTarget;
    @Mock
    private GrpcLimitProperties grpcLimitProperties;
    @Mock
    private GrpcRequestMetadata grpcRequestMetadata;
    @InjectMocks
    private FactStoreGrpcService uut;
    @Captor
    private ArgumentCaptor<List<Fact>> acFactList;
    private final ProtoConverter conv = new ProtoConverter();
    @Captor
    private ArgumentCaptor<SubscriptionRequestTO> reqCaptor;
    private final FactCastUser PRINCIPAL = new FactCastUser(FactCastAccount.GOD, "DISABLED");

    @BeforeEach
    void setUp() {
        this.uut = new FactStoreGrpcService(this.backend, this.meta);
        SecurityContextHolder.setContext((SecurityContext)new SecurityContext(){
            private Authentication testToken = new TestToken(new FactCastUser(FactCastAccount.GOD, "DISABLED"));
            private static final long serialVersionUID = 1L;

            public void setAuthentication(Authentication authentication) {
                this.testToken = authentication;
            }

            public Authentication getAuthentication() {
                return this.testToken;
            }
        });
    }

    @Test
    void currentTime() {
        FactStore store = (FactStore)Mockito.mock(FactStore.class);
        FactStoreGrpcService uut = new FactStoreGrpcService(store, this.meta);
        Mockito.when((Object)store.currentTime()).thenReturn((Object)101L);
        StreamObserver stream = (StreamObserver)Mockito.mock(StreamObserver.class);
        uut.currentTime(FactStoreProto.MSG_Empty.getDefaultInstance(), stream);
        ((StreamObserver)Mockito.verify((Object)stream)).onNext((Object)((FactStoreProto.MSG_CurrentDatabaseTime)Mockito.eq((Object)new ProtoConverter().toProto(101L))));
        ((StreamObserver)Mockito.verify((Object)stream)).onCompleted();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{stream});
    }

    @Test
    void currentTimeWithException() {
        Assertions.assertThatThrownBy(() -> {
            Mockito.when((Object)this.backend.currentTime()).thenThrow(RuntimeException.class);
            StreamObserver stream = (StreamObserver)Mockito.mock(StreamObserver.class);
            this.uut.currentTime(FactStoreProto.MSG_Empty.getDefaultInstance(), stream);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{stream});
        }).isInstanceOf(RuntimeException.class);
    }

    @Test
    void fetchById() {
        FactStore store = (FactStore)Mockito.mock(FactStore.class);
        FactStoreGrpcService uut = new FactStoreGrpcService(store, this.meta);
        Fact fact = Fact.builder().ns("ns").type("type").id(UUID.randomUUID()).buildWithoutPayload();
        Optional<Fact> expected = Optional.of(fact);
        Mockito.when((Object)store.fetchById(fact.id())).thenReturn(expected);
        StreamObserver stream = (StreamObserver)Mockito.mock(StreamObserver.class);
        uut.fetchById(new ProtoConverter().toProto(fact.id()), stream);
        ((StreamObserver)Mockito.verify((Object)stream)).onNext((Object)((FactStoreProto.MSG_OptionalFact)Mockito.eq((Object)new ProtoConverter().toProto(Optional.of(fact)))));
        ((StreamObserver)Mockito.verify((Object)stream)).onCompleted();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{stream});
    }

    @Test
    void fetchByIEmpty() {
        FactStore store = (FactStore)Mockito.mock(FactStore.class);
        FactStoreGrpcService uut = new FactStoreGrpcService(store, this.meta);
        Optional expected = Optional.empty();
        UUID id = UUID.randomUUID();
        Mockito.when((Object)store.fetchById(id)).thenReturn(expected);
        StreamObserver stream = (StreamObserver)Mockito.mock(StreamObserver.class);
        uut.fetchById(new ProtoConverter().toProto(id), stream);
        ((StreamObserver)Mockito.verify((Object)stream)).onNext((Object)((FactStoreProto.MSG_OptionalFact)Mockito.eq((Object)new ProtoConverter().toProto(Optional.empty()))));
        ((StreamObserver)Mockito.verify((Object)stream)).onCompleted();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{stream});
    }

    @Test
    void fetchByIdThrowingException() {
        Assertions.assertThatThrownBy(() -> {
            FactStore store = (FactStore)Mockito.mock(FactStore.class);
            FactStoreGrpcService uut = new FactStoreGrpcService(store, this.meta);
            Fact fact = Fact.builder().ns("ns").type("type").id(UUID.randomUUID()).buildWithoutPayload();
            Mockito.when((Object)store.fetchById(fact.id())).thenThrow(IllegalMonitorStateException.class);
            StreamObserver stream = (StreamObserver)Mockito.mock(StreamObserver.class);
            uut.fetchById(new ProtoConverter().toProto(fact.id()), stream);
            ((StreamObserver)Mockito.verify((Object)stream, (VerificationMode)Mockito.never())).onNext((Object)((FactStoreProto.MSG_OptionalFact)Mockito.any()));
            ((StreamObserver)Mockito.verify((Object)stream, (VerificationMode)Mockito.never())).onCompleted();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{stream});
        }).isInstanceOf(IllegalMonitorStateException.class);
    }

    @Test
    void fetchByIdAndVersion() throws TransformationException {
        FactStore store = (FactStore)Mockito.mock(FactStore.class);
        FactStoreGrpcService uut = new FactStoreGrpcService(store, this.meta);
        Fact fact = Fact.builder().ns("ns").type("type").id(UUID.randomUUID()).buildWithoutPayload();
        Optional<Fact> expected = Optional.of(fact);
        Mockito.when((Object)store.fetchByIdAndVersion(fact.id(), 1)).thenReturn(expected);
        StreamObserver stream = (StreamObserver)Mockito.mock(StreamObserver.class);
        uut.fetchByIdAndVersion(new ProtoConverter().toProto(fact.id(), 1), stream);
        ((StreamObserver)Mockito.verify((Object)stream)).onNext((Object)((FactStoreProto.MSG_OptionalFact)Mockito.eq((Object)new ProtoConverter().toProto(Optional.of(fact)))));
        ((StreamObserver)Mockito.verify((Object)stream)).onCompleted();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{stream});
    }

    @Test
    void fetchByIdAndVersionEmpty() throws TransformationException {
        FactStore store = (FactStore)Mockito.mock(FactStore.class);
        FactStoreGrpcService uut = new FactStoreGrpcService(store, this.meta);
        Optional expected = Optional.empty();
        @NonNull UUID id = UUID.randomUUID();
        Mockito.when((Object)store.fetchByIdAndVersion(id, 1)).thenReturn(expected);
        StreamObserver stream = (StreamObserver)Mockito.mock(StreamObserver.class);
        uut.fetchByIdAndVersion(new ProtoConverter().toProto(id, 1), stream);
        ((StreamObserver)Mockito.verify((Object)stream)).onNext((Object)((FactStoreProto.MSG_OptionalFact)Mockito.eq((Object)new ProtoConverter().toProto(Optional.empty()))));
        ((StreamObserver)Mockito.verify((Object)stream)).onCompleted();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{stream});
    }

    @Test
    void testPublishNull() {
        FactStoreGrpcServiceTest.expectNPE(() -> this.uut.publish(null, (StreamObserver)Mockito.mock(StreamObserver.class)));
    }

    @Test
    void testPublishNone() {
        ((FactStore)Mockito.doNothing().when((Object)this.backend)).publish((List)this.acFactList.capture());
        FactStoreProto.MSG_Facts r = FactStoreProto.MSG_Facts.newBuilder().build();
        this.uut.publish(r, (StreamObserver)Mockito.mock(StreamObserver.class));
        ((FactStore)Mockito.verify((Object)this.backend)).publish(Mockito.anyList());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((List)this.acFactList.getValue()).isEmpty());
    }

    @Test
    void testPublishSome() {
        ((FactStore)Mockito.doNothing().when((Object)this.backend)).publish((List)this.acFactList.capture());
        FactStoreProto.MSG_Facts.Builder b = FactStoreProto.MSG_Facts.newBuilder();
        Fact f1 = Fact.builder().ns("test").build("{}");
        Fact f2 = Fact.builder().ns("test").build("{}");
        FactStoreProto.MSG_Fact msg1 = this.conv.toProto(f1);
        FactStoreProto.MSG_Fact msg2 = this.conv.toProto(f2);
        b.addAllFact(Arrays.asList(msg1, msg2));
        FactStoreProto.MSG_Facts r = b.build();
        this.uut.publish(r, (StreamObserver)Mockito.mock(StreamObserver.class));
        ((FactStore)Mockito.verify((Object)this.backend)).publish(Mockito.anyList());
        List facts = (List)this.acFactList.getValue();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)facts.isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)facts.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)f1.id(), (Object)((Fact)facts.get(0)).id());
        org.junit.jupiter.api.Assertions.assertEquals((Object)f2.id(), (Object)((Fact)facts.get(1)).id());
    }

    @Test
    void testPublishTagging() {
        String clientId = "someApplication";
        Mockito.when((Object)this.grpcRequestMetadata.clientId()).thenReturn(Optional.of(clientId));
        ((FactStore)Mockito.doNothing().when((Object)this.backend)).publish((List)this.acFactList.capture());
        this.uut = new FactStoreGrpcService(this.backend, this.grpcRequestMetadata);
        Fact f1 = Fact.builder().ns("test").build("{}");
        FactStoreProto.MSG_Fact msg1 = this.conv.toProto(f1);
        FactStoreProto.MSG_Facts.Builder b = FactStoreProto.MSG_Facts.newBuilder();
        b.addAllFact(Arrays.asList(msg1));
        FactStoreProto.MSG_Facts r = b.build();
        this.uut.publish(r, (StreamObserver)Mockito.mock(StreamObserver.class));
        ((FactStore)Mockito.verify((Object)this.backend)).publish((List)this.acFactList.capture());
        List facts = (List)this.acFactList.getValue();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)facts.isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)facts.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)f1.id(), (Object)((Fact)facts.get(0)).id());
        org.junit.jupiter.api.Assertions.assertEquals((Object)clientId, (Object)((Fact)facts.get(0)).meta("source"));
    }

    @Test
    void testSubscribeFacts() {
        SubscriptionRequest req = SubscriptionRequest.catchup((FactSpec)FactSpec.ns((String)"foo")).fromNowOn();
        Mockito.when((Object)this.backend.subscribe((SubscriptionRequestTO)this.reqCaptor.capture(), (FactObserver)Mockito.any())).thenReturn(null);
        this.uut.subscribe(new ProtoConverter().toProto(SubscriptionRequestTO.forFacts((SubscriptionRequest)req)), (StreamObserver)Mockito.mock(ServerCallStreamObserver.class));
        ((FactStore)Mockito.verify((Object)this.backend)).subscribe((SubscriptionRequestTO)Mockito.any(), (FactObserver)Mockito.any());
    }

    @Test
    void testSubscribeExhaustContinous() {
        this.uut = new FactStoreGrpcService(this.backend, this.meta, new GrpcLimitProperties().initialNumberOfFollowRequestsAllowedPerClient(3).numberOfFollowRequestsAllowedPerClientPerMinute(1));
        SubscriptionRequest req = SubscriptionRequest.catchup((FactSpec)FactSpec.ns((String)"foo")).fromNowOn();
        Mockito.when((Object)this.backend.subscribe((SubscriptionRequestTO)this.reqCaptor.capture(), (FactObserver)Mockito.any())).thenReturn(null);
        StatusRuntimeException sre = (StatusRuntimeException)org.junit.jupiter.api.Assertions.assertThrows(StatusRuntimeException.class, () -> {
            for (int i = 0; i < 10; ++i) {
                this.uut.subscribe(new ProtoConverter().toProto(SubscriptionRequestTO.forFacts((SubscriptionRequest)req).continuous(true)), (StreamObserver)Mockito.mock(ServerCallStreamObserver.class));
            }
        });
        org.junit.jupiter.api.Assertions.assertEquals((Object)Status.RESOURCE_EXHAUSTED, (Object)sre.getStatus());
    }

    @Test
    void testSubscribeExhaustNotTriggeredWithDifferentRequests() {
        this.uut = new FactStoreGrpcService(this.backend, this.meta, new GrpcLimitProperties().initialNumberOfCatchupRequestsAllowedPerClient(3).numberOfCatchupRequestsAllowedPerClientPerMinute(1).initialNumberOfFollowRequestsAllowedPerClient(3).numberOfFollowRequestsAllowedPerClientPerMinute(3));
        Mockito.when((Object)this.backend.subscribe((SubscriptionRequestTO)this.reqCaptor.capture(), (FactObserver)Mockito.any())).thenReturn(null);
        for (int i = 0; i < 10; ++i) {
            SubscriptionRequest req = SubscriptionRequest.catchup((FactSpec)FactSpec.ns((String)"foo").aggId(UUID.randomUUID())).fromNowOn();
            this.uut.subscribe(new ProtoConverter().toProto(SubscriptionRequestTO.forFacts((SubscriptionRequest)req).continuous(true)), (StreamObserver)Mockito.mock(ServerCallStreamObserver.class));
        }
    }

    @Test
    void testSubscribeExhaustCheckDisabled() {
        this.uut = new FactStoreGrpcService(this.backend, this.meta, new GrpcLimitProperties().initialNumberOfCatchupRequestsAllowedPerClient(3).numberOfCatchupRequestsAllowedPerClientPerMinute(1).initialNumberOfFollowRequestsAllowedPerClient(3).numberOfFollowRequestsAllowedPerClientPerMinute(1).disabled(true));
        SubscriptionRequest req = SubscriptionRequest.catchup((FactSpec)FactSpec.ns((String)"foo")).fromNowOn();
        Mockito.when((Object)this.backend.subscribe((SubscriptionRequestTO)this.reqCaptor.capture(), (FactObserver)Mockito.any())).thenReturn(null);
        for (int i = 0; i < 10; ++i) {
            this.uut.subscribe(new ProtoConverter().toProto(SubscriptionRequestTO.forFacts((SubscriptionRequest)req).continuous(true)), (StreamObserver)Mockito.mock(ServerCallStreamObserver.class));
        }
    }

    @Test
    void testSubscribeExhaustCatchup() {
        this.uut = new FactStoreGrpcService(this.backend, this.meta, new GrpcLimitProperties().initialNumberOfCatchupRequestsAllowedPerClient(3).numberOfCatchupRequestsAllowedPerClientPerMinute(1).initialNumberOfFollowRequestsAllowedPerClient(3).numberOfFollowRequestsAllowedPerClientPerMinute(1));
        SubscriptionRequest req = SubscriptionRequest.catchup((FactSpec)FactSpec.ns((String)"foo")).fromNowOn();
        Mockito.when((Object)this.backend.subscribe((SubscriptionRequestTO)this.reqCaptor.capture(), (FactObserver)Mockito.any())).thenReturn(null);
        StatusRuntimeException sre = (StatusRuntimeException)org.junit.jupiter.api.Assertions.assertThrows(StatusRuntimeException.class, () -> {
            for (int i = 0; i < 10; ++i) {
                this.uut.subscribe(new ProtoConverter().toProto(SubscriptionRequestTO.forFacts((SubscriptionRequest)req).continuous(true)), (StreamObserver)Mockito.mock(ServerCallStreamObserver.class));
            }
        });
        org.junit.jupiter.api.Assertions.assertEquals((Object)Status.RESOURCE_EXHAUSTED, (Object)sre.getStatus());
    }

    @Test
    public void testSerialOf() {
        this.uut = new FactStoreGrpcService(this.backend, this.meta);
        StreamObserver so = (StreamObserver)Mockito.mock(StreamObserver.class);
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> this.uut.serialOf(null, so));
        UUID id = new UUID(0L, 1L);
        OptionalLong twenty_two = OptionalLong.of(22L);
        Mockito.when((Object)this.backend.serialOf(id)).thenReturn((Object)twenty_two);
        this.uut.serialOf(this.conv.toProto(id), so);
        ((StreamObserver)Mockito.verify((Object)so)).onCompleted();
        ((StreamObserver)Mockito.verify((Object)so)).onNext((Object)this.conv.toProto(twenty_two));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{so});
    }

    @Test
    public void testSerialOfThrows() {
        this.uut = new FactStoreGrpcService(this.backend, this.meta);
        StreamObserver so = (StreamObserver)Mockito.mock(StreamObserver.class);
        Mockito.when((Object)this.backend.serialOf((UUID)Mockito.any(UUID.class))).thenThrow(UnsupportedOperationException.class);
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> this.uut.serialOf(this.conv.toProto(UUID.randomUUID()), so));
    }

    @Test
    public void testEnumerateNamespaces() {
        this.uut = new FactStoreGrpcService(this.backend, this.meta);
        StreamObserver so = (StreamObserver)Mockito.mock(StreamObserver.class);
        Mockito.when((Object)this.backend.enumerateNamespaces()).thenReturn((Object)Sets.newHashSet((Object[])new String[]{"foo", "bar"}));
        this.uut.enumerateNamespaces(this.conv.empty(), so);
        ((StreamObserver)Mockito.verify((Object)so)).onCompleted();
        ((StreamObserver)Mockito.verify((Object)so)).onNext(Mockito.eq((Object)this.conv.toProto((Set)Sets.newHashSet((Object[])new String[]{"foo", "bar"}))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{so});
    }

    @Test
    public void testEnumerateNamespacesThrows() {
        Assertions.assertThatThrownBy(() -> {
            this.uut = new FactStoreGrpcService(this.backend, this.meta);
            StreamObserver so = (StreamObserver)Mockito.mock(StreamObserver.class);
            Mockito.when((Object)this.backend.enumerateNamespaces()).thenThrow(UnsupportedOperationException.class);
            this.uut.enumerateNamespaces(this.conv.empty(), so);
        }).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testEnumerateTypes() {
        this.uut = new FactStoreGrpcService(this.backend, this.meta);
        StreamObserver so = (StreamObserver)Mockito.mock(StreamObserver.class);
        Mockito.when((Object)this.backend.enumerateTypes((String)Mockito.eq((Object)"ns"))).thenReturn((Object)Sets.newHashSet((Object[])new String[]{"foo", "bar"}));
        this.uut.enumerateTypes(this.conv.toProto("ns"), so);
        ((StreamObserver)Mockito.verify((Object)so)).onCompleted();
        ((StreamObserver)Mockito.verify((Object)so)).onNext(Mockito.eq((Object)this.conv.toProto((Set)Sets.newHashSet((Object[])new String[]{"foo", "bar"}))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{so});
    }

    @Test
    public void testEnumerateTypesThrows() {
        Assertions.assertThatThrownBy(() -> {
            this.uut = new FactStoreGrpcService(this.backend, this.meta);
            StreamObserver so = (StreamObserver)Mockito.mock(StreamObserver.class);
            Mockito.when((Object)this.backend.enumerateTypes((String)Mockito.eq((Object)"ns"))).thenThrow(UnsupportedOperationException.class);
            this.uut.enumerateTypes(this.conv.toProto("ns"), so);
        }).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testPublishThrows() {
        Assertions.assertThatThrownBy(() -> {
            ((FactStore)Mockito.doThrow(UnsupportedOperationException.class).when((Object)this.backend)).publish(Mockito.anyList());
            ArrayList toPublish = Lists.newArrayList((Object[])new Fact[]{Fact.builder().build("{}")});
            StreamObserver so = (StreamObserver)Mockito.mock(StreamObserver.class);
            this.uut.publish(this.conv.toProto((List)toPublish), so);
        }).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testHandshake() {
        StreamObserver so = (StreamObserver)Mockito.mock(StreamObserver.class);
        this.uut.handshake(this.conv.empty(), so);
        ((StreamObserver)Mockito.verify((Object)so)).onCompleted();
        ((StreamObserver)Mockito.verify((Object)so)).onNext(Mockito.any(FactStoreProto.MSG_ServerConfig.class));
    }

    @Test
    public void testRetrieveImplementationVersion() {
        this.uut = (FactStoreGrpcService)Mockito.spy((Object)this.uut);
        Mockito.when((Object)this.uut.getProjectProperties()).thenReturn((Object)this.getClass().getResource("/test.properties"));
        HashMap map = new HashMap();
        this.uut.retrieveImplementationVersion(map);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"9.9.9", map.get(Capabilities.FACTCAST_IMPL_VERSION.toString()));
    }

    @Test
    public void testRetrieveImplementationVersionEmptyPropertyFile() {
        this.uut = (FactStoreGrpcService)Mockito.spy((Object)this.uut);
        Mockito.when((Object)this.uut.getProjectProperties()).thenReturn((Object)this.getClass().getResource("/no-version.properties"));
        HashMap map = new HashMap();
        this.uut.retrieveImplementationVersion(map);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"UNKNOWN", map.get(Capabilities.FACTCAST_IMPL_VERSION.toString()));
    }

    @Test
    public void testRetrieveImplementationVersionCannotReadFile() throws Exception {
        this.uut = (FactStoreGrpcService)Mockito.spy((Object)this.uut);
        URL url = (URL)Mockito.mock(URL.class);
        Mockito.when((Object)url.openStream()).thenReturn(null);
        Mockito.when((Object)this.uut.getProjectProperties()).thenReturn((Object)url);
        HashMap map = new HashMap();
        this.uut.retrieveImplementationVersion(map);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"UNKNOWN", map.get(Capabilities.FACTCAST_IMPL_VERSION.toString()));
    }

    @Test
    public void testInvalidate() {
        UUID id = UUID.randomUUID();
        FactStoreProto.MSG_UUID req = this.conv.toProto(id);
        StreamObserver o = (StreamObserver)Mockito.mock(StreamObserver.class);
        this.uut.invalidate(req, o);
        ((FactStore)Mockito.verify((Object)this.backend)).invalidate((StateToken)Mockito.eq((Object)new StateToken(id)));
        ((StreamObserver)Mockito.verify((Object)o)).onNext(Mockito.any());
        ((StreamObserver)Mockito.verify((Object)o)).onCompleted();
        ((FactStore)Mockito.doThrow((Throwable[])new Throwable[]{new StatusRuntimeException(Status.DATA_LOSS)}).when((Object)this.backend)).invalidate((StateToken)Mockito.any());
        id = UUID.randomUUID();
        req = this.conv.toProto(id);
        o = (StreamObserver)Mockito.mock(StreamObserver.class);
        Assertions.assertThatThrownBy(() -> this.uut.invalidate(req, o)).isInstanceOf(StatusRuntimeException.class);
        ((FactStore)Mockito.verify((Object)this.backend)).invalidate((StateToken)Mockito.eq((Object)new StateToken(id)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{o});
    }

    @Test
    public void testStateFor() {
        UUID id = UUID.randomUUID();
        StateForRequest sfr = new StateForRequest((List)Lists.newArrayList((Object[])new UUID[]{id}), "foo");
        FactStoreProto.MSG_StateForRequest req = this.conv.toProto(sfr);
        StreamObserver o = (StreamObserver)Mockito.mock(StreamObserver.class);
        UUID token = UUID.randomUUID();
        Mockito.when((Object)this.backend.stateFor((List)Mockito.any())).thenReturn((Object)new StateToken(token));
        this.uut.stateFor(req, o);
        ((FactStore)Mockito.verify((Object)this.backend)).stateFor((List)Mockito.any());
        ((StreamObserver)Mockito.verify((Object)o)).onNext(Mockito.eq((Object)this.conv.toProto(token)));
        ((StreamObserver)Mockito.verify((Object)o)).onCompleted();
        ((FactStore)Mockito.doThrow((Throwable[])new Throwable[]{new StatusRuntimeException(Status.DATA_LOSS)}).when((Object)this.backend)).stateFor((List)Mockito.any());
        id = UUID.randomUUID();
        sfr = new StateForRequest((List)Lists.newArrayList((Object[])new UUID[]{id}), "foo");
        req = this.conv.toProto(sfr);
        o = (StreamObserver)Mockito.mock(StreamObserver.class);
        Assertions.assertThatThrownBy(() -> this.uut.stateFor(req, o)).isInstanceOf(StatusRuntimeException.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{o});
    }

    @Test
    public void testPublishConditional() {
        UUID id = UUID.randomUUID();
        ConditionalPublishRequest sfr = new ConditionalPublishRequest((List)Lists.newArrayList(), id);
        FactStoreProto.MSG_ConditionalPublishRequest req = this.conv.toProto(sfr);
        StreamObserver o = (StreamObserver)Mockito.mock(StreamObserver.class);
        Mockito.when((Object)this.backend.publishIfUnchanged((List)Mockito.any(), (Optional)Mockito.any())).thenReturn((Object)true);
        this.uut.publishConditional(req, o);
        ((FactStore)Mockito.verify((Object)this.backend)).publishIfUnchanged((List)Mockito.eq((Object)Lists.newArrayList()), (Optional)Mockito.eq(Optional.of(new StateToken(id))));
        ((StreamObserver)Mockito.verify((Object)o)).onNext(Mockito.eq((Object)this.conv.toProto(true)));
        ((StreamObserver)Mockito.verify((Object)o)).onCompleted();
        ((FactStore)Mockito.doThrow((Throwable[])new Throwable[]{new StatusRuntimeException(Status.DATA_LOSS)}).when((Object)this.backend)).publishIfUnchanged((List)Mockito.any(), (Optional)Mockito.any());
        id = UUID.randomUUID();
        sfr = new ConditionalPublishRequest((List)Lists.newArrayList(), id);
        req = this.conv.toProto(sfr);
        o = (StreamObserver)Mockito.mock(StreamObserver.class);
        Assertions.assertThatThrownBy(() -> this.uut.publishConditional(req, o)).isInstanceOf(StatusRuntimeException.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{o});
    }

    @Test
    public void testSourceTaggingPublishConditional() {
        String clientId = "someApplication";
        Mockito.when((Object)this.grpcRequestMetadata.clientId()).thenReturn(Optional.of(clientId));
        this.uut = new FactStoreGrpcService(this.backend, this.grpcRequestMetadata);
        UUID id = UUID.randomUUID();
        Fact f = Fact.builder().ns("foo").type("bar").buildWithoutPayload();
        ConditionalPublishRequest sfr = new ConditionalPublishRequest((List)Lists.newArrayList((Object[])new Fact[]{f}), id);
        FactStoreProto.MSG_ConditionalPublishRequest req = this.conv.toProto(sfr);
        StreamObserver o = (StreamObserver)Mockito.mock(StreamObserver.class);
        Mockito.when((Object)this.backend.publishIfUnchanged((List)this.acFactList.capture(), (Optional)Mockito.eq(Optional.of(new StateToken(id))))).thenReturn((Object)true);
        this.uut.publishConditional(req, o);
        Fact fact = (Fact)((List)this.acFactList.getAllValues().get(0)).get(0);
        Assertions.assertThat((String)fact.meta("source")).isEqualTo(clientId);
        ((StreamObserver)Mockito.verify((Object)o)).onNext(Mockito.eq((Object)this.conv.toProto(true)));
        ((StreamObserver)Mockito.verify((Object)o)).onCompleted();
    }

    @Test
    public void testAssertCanReadString() {
        FactCastAccount account = (FactCastAccount)Mockito.mock(FactCastAccount.class);
        Mockito.when((Object)account.id()).thenReturn((Object)"mock");
        Mockito.when((Object)account.canRead(Mockito.anyString())).thenReturn((Object)false);
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestToken(new FactCastUser(account, "s3cr3t")));
        try {
            this.uut.assertCanRead("foo");
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (StatusRuntimeException s) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)s.getStatus(), (Object)Status.PERMISSION_DENIED);
        }
        catch (Throwable s) {
            org.junit.jupiter.api.Assertions.fail((Throwable)s);
        }
    }

    @Test
    public void testAssertCanReadStrings() {
        FactCastAccount account = (FactCastAccount)Mockito.mock(FactCastAccount.class);
        Mockito.when((Object)account.id()).thenReturn((Object)"mock");
        Mockito.when((Object)account.canRead(Mockito.anyString())).thenReturn((Object)false);
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestToken(new FactCastUser(account, "s3cr3t")));
        try {
            this.uut.assertCanRead((List)Lists.newArrayList((Object[])new String[]{"foo", "bar"}));
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (StatusRuntimeException s) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)s.getStatus(), (Object)Status.PERMISSION_DENIED);
        }
        catch (Throwable s) {
            org.junit.jupiter.api.Assertions.fail((Throwable)s);
        }
    }

    @Test
    public void testAssertCanWriteStrings() {
        FactCastAccount account = (FactCastAccount)Mockito.mock(FactCastAccount.class);
        Mockito.when((Object)account.id()).thenReturn((Object)"mock");
        Mockito.when((Object)account.canWrite(Mockito.anyString())).thenReturn((Object)false);
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestToken(new FactCastUser(account, "s3cr3t")));
        try {
            this.uut.assertCanWrite((List)Lists.newArrayList((Object[])new String[]{"foo", "bar"}));
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (StatusRuntimeException s) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)s.getStatus(), (Object)Status.PERMISSION_DENIED);
        }
        catch (Throwable s) {
            org.junit.jupiter.api.Assertions.fail((Throwable)s);
        }
    }

    public static void expectNPE(Runnable r) {
        FactStoreGrpcServiceTest.expect(r, NullPointerException.class, IllegalArgumentException.class);
    }

    public static void expect(Runnable r, Class<? extends Throwable> ... ex) {
        block2: {
            try {
                r.run();
                org.junit.jupiter.api.Assertions.fail((String)("expected " + Arrays.toString(ex)));
            }
            catch (Throwable actual) {
                boolean matches = Arrays.stream(ex).anyMatch(e -> e.isInstance(actual));
                if (matches) break block2;
                org.junit.jupiter.api.Assertions.fail((String)("Wrong exception, expected " + Arrays.toString(ex) + " but got " + actual));
            }
        }
    }

    @Test
    void stateForSpecsJson() {
        ArrayList list = Lists.newArrayList((Object[])new FactSpec[]{FactSpec.ns((String)"foo").type("bar").version(1), FactSpec.ns((String)"foo").type("bar2").version(2)});
        FactStoreProto.MSG_FactSpecsJson req = this.conv.toProtoFactSpecs((List)list);
        StreamObserver obs = (StreamObserver)Mockito.mock(StreamObserver.class);
        UUID tokenId = UUID.randomUUID();
        Mockito.when((Object)this.backend.stateFor((List)Mockito.eq((Object)list))).thenReturn((Object)new StateToken(tokenId));
        this.uut.stateForSpecsJson(req, obs);
        ((StreamObserver)Mockito.verify((Object)obs)).onNext((Object)((FactStoreProto.MSG_UUID)Mockito.eq((Object)this.conv.toProto(tokenId))));
        ((StreamObserver)Mockito.verify((Object)obs)).onCompleted();
    }

    @Test
    void stateForSpecsJsonEmpty() {
        ArrayList list = Lists.newArrayList();
        FactStoreProto.MSG_FactSpecsJson req = this.conv.toProtoFactSpecs((List)list);
        StreamObserver obs = (StreamObserver)Mockito.mock(StreamObserver.class);
        this.uut.stateForSpecsJson(req, obs);
        ((StreamObserver)Mockito.verify((Object)obs)).onError((Throwable)Mockito.any(IllegalArgumentException.class));
    }

    @Test
    void invalidateStateToken() {
        UUID id = UUID.randomUUID();
        FactStoreProto.MSG_UUID req = this.conv.toProto(id);
        StateToken stateToken = new StateToken(id);
        StreamObserver obs = (StreamObserver)Mockito.mock(StreamObserver.class);
        this.uut.invalidate(req, obs);
        ((FactStore)Mockito.verify((Object)this.backend)).invalidate((StateToken)Mockito.eq((Object)stateToken));
        ((StreamObserver)Mockito.verify((Object)obs)).onNext((Object)((FactStoreProto.MSG_Empty)Mockito.any(FactStoreProto.MSG_Empty.class)));
        ((StreamObserver)Mockito.verify((Object)obs)).onCompleted();
    }

    @Test
    void invalidateStateTokenWithError() {
        Assertions.assertThatThrownBy(() -> {
            UUID id = UUID.randomUUID();
            FactStoreProto.MSG_UUID req = this.conv.toProto(id);
            StateToken stateToken = new StateToken(id);
            StreamObserver obs = (StreamObserver)Mockito.mock(StreamObserver.class);
            ((FactStore)Mockito.doThrow(RuntimeException.class).when((Object)this.backend)).invalidate((StateToken)Mockito.any());
            this.uut.invalidate(req, obs);
            ((FactStore)Mockito.verify((Object)this.backend)).invalidate((StateToken)Mockito.eq((Object)stateToken));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{obs});
        }).isInstanceOf(RuntimeException.class);
    }

    @Test
    void getFactcastUserWithoutPrincipal() throws StatusException {
        SecurityContextHolder.setContext((SecurityContext)new SecurityContext(){
            private Authentication testToken = new TokenWithoutPrincipal();
            private static final long serialVersionUID = 1L;

            public void setAuthentication(Authentication authentication) {
                this.testToken = authentication;
            }

            public Authentication getAuthentication() {
                return this.testToken;
            }
        });
        org.junit.jupiter.api.Assertions.assertThrows(StatusRuntimeException.class, () -> this.uut.getFactcastUser());
    }

    @Test
    void clearSnapshot() {
        SnapshotId id = SnapshotId.of((String)"foo", (UUID)UUID.randomUUID());
        FactStoreProto.MSG_SnapshotId req = this.conv.toProto(id);
        StreamObserver obs = (StreamObserver)Mockito.mock(StreamObserver.class);
        this.uut.clearSnapshot(req, obs);
        ((FactStore)Mockito.verify((Object)this.backend)).clearSnapshot((SnapshotId)Mockito.eq((Object)id));
        ((StreamObserver)Mockito.verify((Object)obs)).onNext((Object)((FactStoreProto.MSG_Empty)Mockito.any(FactStoreProto.MSG_Empty.class)));
        ((StreamObserver)Mockito.verify((Object)obs)).onCompleted();
    }

    @Test
    void clearSnapshotWithException() {
        Assertions.assertThatThrownBy(() -> {
            SnapshotId id = SnapshotId.of((String)"foo", (UUID)UUID.randomUUID());
            FactStoreProto.MSG_SnapshotId req = this.conv.toProto(id);
            StreamObserver obs = (StreamObserver)Mockito.mock(StreamObserver.class);
            ((FactStore)Mockito.doThrow(TestException.class).when((Object)this.backend)).clearSnapshot((SnapshotId)Mockito.eq((Object)id));
            this.uut.clearSnapshot(req, obs);
        }).isInstanceOf(TestException.class);
    }

    @Test
    void getSnapshot() {
        SnapshotId id = SnapshotId.of((String)"foo", (UUID)UUID.randomUUID());
        FactStoreProto.MSG_SnapshotId req = this.conv.toProto(id);
        StreamObserver obs = (StreamObserver)Mockito.mock(StreamObserver.class);
        Snapshot snap = new Snapshot(id, UUID.randomUUID(), "foo".getBytes(), false);
        Optional<Snapshot> optSnap = Optional.of(snap);
        Mockito.when((Object)this.backend.getSnapshot(id)).thenReturn(optSnap);
        this.uut.getSnapshot(req, obs);
        ((FactStore)Mockito.verify((Object)this.backend)).getSnapshot((SnapshotId)Mockito.eq((Object)id));
        ((StreamObserver)Mockito.verify((Object)obs)).onNext((Object)((FactStoreProto.MSG_OptionalSnapshot)Mockito.eq((Object)this.conv.toProtoSnapshot(optSnap))));
        ((StreamObserver)Mockito.verify((Object)obs)).onCompleted();
    }

    @Test
    void getSnapshotEmpty() {
        SnapshotId id = SnapshotId.of((String)"foo", (UUID)UUID.randomUUID());
        FactStoreProto.MSG_SnapshotId req = this.conv.toProto(id);
        StreamObserver obs = (StreamObserver)Mockito.mock(StreamObserver.class);
        Optional optSnap = Optional.empty();
        Mockito.when((Object)this.backend.getSnapshot(id)).thenReturn(optSnap);
        this.uut.getSnapshot(req, obs);
        ((FactStore)Mockito.verify((Object)this.backend)).getSnapshot((SnapshotId)Mockito.eq((Object)id));
        ((StreamObserver)Mockito.verify((Object)obs)).onNext((Object)((FactStoreProto.MSG_OptionalSnapshot)Mockito.eq((Object)this.conv.toProtoSnapshot(optSnap))));
        ((StreamObserver)Mockito.verify((Object)obs)).onCompleted();
    }

    @Test
    void getSnapshotException() {
        Assertions.assertThatThrownBy(() -> {
            SnapshotId id = SnapshotId.of((String)"foo", (UUID)UUID.randomUUID());
            FactStoreProto.MSG_SnapshotId req = this.conv.toProto(id);
            StreamObserver obs = (StreamObserver)Mockito.mock(StreamObserver.class);
            Optional optSnap = Optional.empty();
            Mockito.when((Object)this.backend.getSnapshot(id)).thenThrow(TestException.class);
            this.uut.getSnapshot(req, obs);
            ((FactStore)Mockito.verify((Object)this.backend)).getSnapshot((SnapshotId)Mockito.eq((Object)id));
        }).isInstanceOf(TestException.class);
    }

    @Test
    void setSnapshot() {
        SnapshotId id = SnapshotId.of((String)"foo", (UUID)UUID.randomUUID());
        Snapshot snap = new Snapshot(id, UUID.randomUUID(), "foo".getBytes(), false);
        FactStoreProto.MSG_Snapshot req = this.conv.toProto(snap);
        StreamObserver obs = (StreamObserver)Mockito.mock(StreamObserver.class);
        this.uut.setSnapshot(req, obs);
        ((FactStore)Mockito.verify((Object)this.backend)).setSnapshot(snap);
        ((StreamObserver)Mockito.verify((Object)obs)).onNext((Object)((FactStoreProto.MSG_Empty)Mockito.any(FactStoreProto.MSG_Empty.class)));
        ((StreamObserver)Mockito.verify((Object)obs)).onCompleted();
    }

    @Test
    void setSnapshotWithException() {
        Assertions.assertThatThrownBy(() -> {
            SnapshotId id = SnapshotId.of((String)"foo", (UUID)UUID.randomUUID());
            Snapshot snap = new Snapshot(id, UUID.randomUUID(), "foo".getBytes(), false);
            FactStoreProto.MSG_Snapshot req = this.conv.toProto(snap);
            StreamObserver obs = (StreamObserver)Mockito.mock(StreamObserver.class);
            ((FactStore)Mockito.doThrow(TestException.class).when((Object)this.backend)).setSnapshot((Snapshot)Mockito.any());
            this.uut.setSnapshot(req, obs);
            ((FactStore)Mockito.verify((Object)this.backend)).setSnapshot(snap);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{obs});
        }).isInstanceOf(TestException.class);
    }

    @Test
    void testHeaderSourceTagging() {
        Fact f = Fact.builder().ns("x").meta("foo", "bar").buildWithoutPayload();
        f = this.uut.tagFactSource(f, "theSourceApplication");
        Assertions.assertThat((String)f.meta("source")).isEqualTo("theSourceApplication");
    }

    @Test
    void testHeaderSourceTaggingOverwrites() {
        Fact f = Fact.builder().ns("x").meta("source", "before").buildWithoutPayload();
        f = this.uut.tagFactSource(f, "after");
        Assertions.assertThat((String)f.meta("source")).isEqualTo("after");
    }

    @Test
    void testHeaderSourceTaggingWithBrokenHeader() {
        Fact f = (Fact)Mockito.spy((Object)Fact.builder().buildWithoutPayload());
        Mockito.when((Object)f.jsonHeader()).thenReturn((Object)"{borken");
        Fact f1 = this.uut.tagFactSource(f, "after");
        org.junit.jupiter.api.Assertions.assertSame((Object)f, (Object)f1);
    }

    static class TestException
    extends RuntimeException {
        private static final long serialVersionUID = -3012325109668741715L;

        TestException() {
        }
    }

    static class TokenWithoutPrincipal
    extends RunAsUserToken {
        private static final long serialVersionUID = 1L;

        public TokenWithoutPrincipal() {
            super("BR0KEN", null, (Object)"", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_AUTHENTICATED"}), null);
        }
    }

    static class TestToken
    extends RunAsUserToken {
        private static final long serialVersionUID = 1L;

        public TestToken(FactCastUser principal) {
            super("GOD", (Object)principal, (Object)"", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_AUTHENTICATED"}), null);
        }
    }
}

