/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.server.grpc;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import org.factcast.grpc.api.CompressionCodecs;
import org.factcast.grpc.api.Headers;
import org.factcast.server.grpc.GrpcCompressionInterceptor;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class GrpcCompressionInterceptorTest {
    private final GrpcCompressionInterceptor uut = new GrpcCompressionInterceptor(new CompressionCodecs());

    GrpcCompressionInterceptorTest() {
    }

    @Test
    void interceptCallWithoutCompression() {
        ServerCall call = (ServerCall)Mockito.mock(ServerCall.class);
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        ServerCallHandler next = (ServerCallHandler)Mockito.mock(ServerCallHandler.class);
        this.uut.interceptCall(call, metadata, next);
        ((ServerCallHandler)Mockito.verify((Object)next)).startCall(call, metadata);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{call});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{next});
    }

    @Test
    void interceptCallGZip() {
        ServerCall call = (ServerCall)Mockito.mock(ServerCall.class);
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        Mockito.when((Object)((String)metadata.get(Headers.MESSAGE_COMPRESSION))).thenReturn((Object)"gzip");
        ServerCallHandler next = (ServerCallHandler)Mockito.mock(ServerCallHandler.class);
        this.uut.interceptCall(call, metadata, next);
        ((ServerCallHandler)Mockito.verify((Object)next)).startCall(call, metadata);
        ((ServerCall)Mockito.verify((Object)call)).setCompression("gzip");
        ((ServerCall)Mockito.verify((Object)call)).setMessageCompression(false);
    }
}

