/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.server.grpc;

import io.grpc.stub.StreamObserver;
import java.util.Arrays;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Function;
import lombok.NonNull;
import org.assertj.core.api.Assertions;
import org.factcast.core.Fact;
import org.factcast.core.subscription.FactStreamInfo;
import org.factcast.core.subscription.observer.FastForwardTarget;
import org.factcast.grpc.api.conv.ProtoConverter;
import org.factcast.grpc.api.gen.FactStoreProto;
import org.factcast.server.grpc.GrpcObserverAdapter;
import org.factcast.server.grpc.GrpcRequestMetadata;
import org.factcast.server.grpc.ServerExceptionLogger;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class GrpcObserverAdapterTest {
    @Mock
    private StreamObserver<FactStoreProto.MSG_Notification> observer;
    @Mock
    private Function<Fact, FactStoreProto.MSG_Notification> projection;
    @Mock
    private ServerExceptionLogger serverExceptionLogger;
    @Captor
    private ArgumentCaptor<FactStoreProto.MSG_Notification> msg;

    @Test
    void testOnComplete() {
        GrpcObserverAdapter uut = new GrpcObserverAdapter("foo", this.observer, this.serverExceptionLogger);
        uut.onComplete();
        ((StreamObserver)Mockito.verify(this.observer)).onCompleted();
    }

    @Test
    void testOnCompleteWithException() {
        GrpcObserverAdapter uut = new GrpcObserverAdapter("foo", this.observer, this.serverExceptionLogger);
        ((StreamObserver)Mockito.doThrow(UnsupportedOperationException.class).when(this.observer)).onCompleted();
        uut.onComplete();
        ((StreamObserver)Mockito.verify(this.observer)).onCompleted();
    }

    @Test
    void testOnCatchup() {
        GrpcObserverAdapter uut = new GrpcObserverAdapter("foo", this.observer, this.serverExceptionLogger);
        ((StreamObserver)Mockito.doNothing().when(this.observer)).onNext((Object)((FactStoreProto.MSG_Notification)this.msg.capture()));
        ((StreamObserver)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onNext((Object)((FactStoreProto.MSG_Notification)Mockito.any()));
        uut.onCatchup();
        ((StreamObserver)Mockito.verify(this.observer)).onNext((Object)((FactStoreProto.MSG_Notification)Mockito.any()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)FactStoreProto.MSG_Notification.Type.Catchup, (Object)((FactStoreProto.MSG_Notification)this.msg.getValue()).getType());
    }

    @Test
    void testFactStreamInfo() {
        GrpcObserverAdapter uut = new GrpcObserverAdapter("foo", this.observer, this.serverExceptionLogger);
        FactStreamInfo info = new FactStreamInfo(2L, 3L);
        uut.onFactStreamInfo(info);
        ((StreamObserver)Mockito.verify(this.observer)).onNext((Object)((FactStoreProto.MSG_Notification)Mockito.eq((Object)new ProtoConverter().createInfoNotification(info))));
    }

    @Test
    void testOnCatchupWithFfwd_noTarget() {
        GrpcRequestMetadata mockGrpcRequestMetaData = (GrpcRequestMetadata)Mockito.mock(GrpcRequestMetadata.class);
        Mockito.when((Object)mockGrpcRequestMetaData.supportsFastForward()).thenReturn((Object)true);
        Mockito.when((Object)mockGrpcRequestMetaData.catchupBatch()).thenReturn((Object)OptionalInt.of(1));
        FastForwardTarget ffwd = FastForwardTarget.of(null, (long)112L);
        GrpcObserverAdapter uut = new GrpcObserverAdapter("foo", this.observer, mockGrpcRequestMetaData, this.serverExceptionLogger);
        ((StreamObserver)Mockito.doNothing().when(this.observer)).onNext((Object)((FactStoreProto.MSG_Notification)this.msg.capture()));
        ((StreamObserver)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onNext((Object)((FactStoreProto.MSG_Notification)Mockito.any()));
        uut.onCatchup();
        ((StreamObserver)Mockito.verify(this.observer, (VerificationMode)Mockito.times((int)1))).onNext((Object)((FactStoreProto.MSG_Notification)Mockito.any()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)FactStoreProto.MSG_Notification.Type.Catchup, (Object)((FactStoreProto.MSG_Notification)this.msg.getAllValues().get(0)).getType());
    }

    @Test
    void testOnCatchupWithFfwd_noTargetSer() {
        GrpcRequestMetadata mockGrpcRequestMetaData = (GrpcRequestMetadata)Mockito.mock(GrpcRequestMetadata.class);
        Mockito.when((Object)mockGrpcRequestMetaData.supportsFastForward()).thenReturn((Object)true);
        Mockito.when((Object)mockGrpcRequestMetaData.catchupBatch()).thenReturn((Object)OptionalInt.of(1));
        FastForwardTarget ffwd = FastForwardTarget.of((UUID)new UUID(1L, 1L), (long)0L);
        GrpcObserverAdapter uut = new GrpcObserverAdapter("foo", this.observer, mockGrpcRequestMetaData, this.serverExceptionLogger);
        ((StreamObserver)Mockito.doNothing().when(this.observer)).onNext((Object)((FactStoreProto.MSG_Notification)this.msg.capture()));
        ((StreamObserver)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onNext((Object)((FactStoreProto.MSG_Notification)Mockito.any()));
        uut.onCatchup();
        ((StreamObserver)Mockito.verify(this.observer, (VerificationMode)Mockito.times((int)1))).onNext((Object)((FactStoreProto.MSG_Notification)Mockito.any()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)FactStoreProto.MSG_Notification.Type.Catchup, (Object)((FactStoreProto.MSG_Notification)this.msg.getAllValues().get(0)).getType());
    }

    @Test
    void testOnCatchupWithoutFfwd_disabled() {
        GrpcRequestMetadata mockGrpcRequestMetaData = (GrpcRequestMetadata)Mockito.mock(GrpcRequestMetadata.class);
        Mockito.when((Object)mockGrpcRequestMetaData.supportsFastForward()).thenReturn((Object)false);
        Mockito.when((Object)mockGrpcRequestMetaData.catchupBatch()).thenReturn((Object)OptionalInt.of(1));
        FastForwardTarget ffwd = FastForwardTarget.of((UUID)new UUID(10L, 10L), (long)112L);
        GrpcObserverAdapter uut = new GrpcObserverAdapter("foo", this.observer, mockGrpcRequestMetaData, this.serverExceptionLogger);
        ((StreamObserver)Mockito.doNothing().when(this.observer)).onNext((Object)((FactStoreProto.MSG_Notification)this.msg.capture()));
        ((StreamObserver)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onNext((Object)((FactStoreProto.MSG_Notification)Mockito.any()));
        uut.onCatchup();
        ((StreamObserver)Mockito.verify(this.observer, (VerificationMode)Mockito.times((int)1))).onNext((Object)((FactStoreProto.MSG_Notification)Mockito.any()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)FactStoreProto.MSG_Notification.Type.Catchup, (Object)((FactStoreProto.MSG_Notification)this.msg.getAllValues().get(0)).getType());
    }

    @Test
    void testOnError() {
        GrpcObserverAdapter uut = new GrpcObserverAdapter("foo", this.observer, this.serverExceptionLogger);
        Exception exception = new Exception();
        ((StreamObserver)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onNext((Object)((FactStoreProto.MSG_Notification)Mockito.any()));
        uut.onError((Throwable)exception);
        ((StreamObserver)Mockito.verify(this.observer)).onError((Throwable)Mockito.any());
        ((ServerExceptionLogger)Mockito.verify((Object)this.serverExceptionLogger)).log((Throwable)exception, "foo");
    }

    @Test
    void testOnNext() {
        ProtoConverter conv = new ProtoConverter();
        GrpcObserverAdapter uut = new GrpcObserverAdapter("foo", this.observer);
        ((StreamObserver)Mockito.doNothing().when(this.observer)).onNext((Object)((FactStoreProto.MSG_Notification)this.msg.capture()));
        ((StreamObserver)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onNext((Object)((FactStoreProto.MSG_Notification)Mockito.any()));
        Fact f = Fact.builder().ns("test").build("{}");
        uut.onNext(f);
        ((StreamObserver)Mockito.verify(this.observer)).onNext((Object)((FactStoreProto.MSG_Notification)Mockito.any()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)FactStoreProto.MSG_Notification.Type.Fact, (Object)((FactStoreProto.MSG_Notification)this.msg.getValue()).getType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)f.id(), (Object)conv.fromProto(((FactStoreProto.MSG_Notification)this.msg.getValue()).getFact()).id());
    }

    @Test
    void testOnFastForwardIfSupported() {
        ProtoConverter conv = new ProtoConverter();
        GrpcObserverAdapter uut = new GrpcObserverAdapter("foo", this.observer);
        UUID id = UUID.randomUUID();
        uut.onFastForward(id);
        ((StreamObserver)Mockito.verify(this.observer)).onNext((Object)((FactStoreProto.MSG_Notification)Mockito.eq((Object)conv.createNotificationForFastForward(id))));
    }

    @Test
    void skipsOnFastForwardIfUnsupported() {
        ProtoConverter conv = new ProtoConverter();
        @NonNull GrpcRequestMetadata meta = (GrpcRequestMetadata)Mockito.mock(GrpcRequestMetadata.class);
        Mockito.when((Object)meta.supportsFastForward()).thenReturn((Object)false);
        GrpcObserverAdapter uut = new GrpcObserverAdapter("foo", this.observer, meta);
        UUID id = UUID.randomUUID();
        uut.onFastForward(id);
        ((StreamObserver)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onNext((Object)((FactStoreProto.MSG_Notification)Mockito.any()));
    }

    @Test
    void createKeepAliveMonitor() {
        GrpcObserverAdapter uut = new GrpcObserverAdapter("foo", this.observer, 300L);
        Assertions.assertThat((Object)uut.keepalive()).isNotNull();
    }

    @Test
    void doesNotCreateKeepAliveMonitorIfUnnecessary() {
        GrpcObserverAdapter uut = new GrpcObserverAdapter("foo", this.observer, 0L);
        Assertions.assertThat((Object)uut.keepalive()).isNull();
    }

    @Test
    void shutdownDelegates() {
        GrpcObserverAdapter uut = new GrpcObserverAdapter("foo", this.observer, 3000L);
        uut.shutdown();
        Assertions.assertThatThrownBy(() -> uut.keepalive().reschedule()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void shutdownIgnoredWhenNoKeepalive() {
        Assertions.assertThatNoException().isThrownBy(() -> {
            GrpcObserverAdapter uut = new GrpcObserverAdapter("foo", this.observer, 0L);
            uut.shutdown();
        });
    }

    public static void expectNPE(Runnable r) {
        GrpcObserverAdapterTest.expect(r, NullPointerException.class, IllegalArgumentException.class);
    }

    public static void expect(Runnable r, Class<? extends Throwable> ... ex) {
        block2: {
            try {
                r.run();
                Assertions.fail((String)("expected " + Arrays.toString(ex)));
            }
            catch (Throwable actual) {
                boolean matches = Arrays.stream(ex).anyMatch(e -> e.isInstance(actual));
                if (matches) break block2;
                Assertions.fail((String)("Wrong exception, expected " + Arrays.toString(ex) + " but got " + actual));
            }
        }
    }
}

