/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.server.grpc;

import io.grpc.Metadata;
import java.util.Optional;
import java.util.OptionalInt;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.api.OptionalIntAssert;
import org.factcast.grpc.api.Headers;
import org.factcast.server.grpc.GrpcRequestMetadata;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class GrpcRequestMetadataTest {
    @InjectMocks
    private GrpcRequestMetadata underTest;

    GrpcRequestMetadataTest() {
    }

    @Nested
    class WhenConsumeringId {
        WhenConsumeringId() {
        }

        @BeforeEach
        void setup() {
        }

        @Test
        void extracts() {
            Metadata headers = new Metadata();
            headers.put(Headers.CLIENT_ID, (Object)"narf");
            GrpcRequestMetadataTest.this.underTest.headers(headers);
            ((OptionalAssert)Assertions.assertThat((Optional)GrpcRequestMetadataTest.this.underTest.clientId()).isPresent()).hasValue((Object)"narf");
        }

        @Test
        void extractsUnset() {
            Metadata headers = new Metadata();
            GrpcRequestMetadataTest.this.underTest.headers(headers);
            Assertions.assertThat((Optional)GrpcRequestMetadataTest.this.underTest.clientId()).isEmpty();
        }
    }

    @Nested
    class WhenForingTest {
        WhenForingTest() {
        }

        @BeforeEach
        void setup() {
        }

        @Test
        void createForTest() {
            GrpcRequestMetadata t = GrpcRequestMetadata.forTest();
            Assertions.assertThat((OptionalInt)t.catchupBatch()).isEmpty();
            Assertions.assertThat((Optional)t.clientId()).isEmpty();
            Assertions.assertThat((boolean)t.supportsFastForward()).isTrue();
        }
    }

    @Nested
    class WhenSupportsingFastForward {
        WhenSupportsingFastForward() {
        }

        @BeforeEach
        void setup() {
        }

        @Test
        void extracts() {
            Metadata headers = new Metadata();
            headers.put(Headers.FAST_FORWARD, (Object)"true");
            GrpcRequestMetadataTest.this.underTest.headers(headers);
            Assertions.assertThat((boolean)GrpcRequestMetadataTest.this.underTest.supportsFastForward()).isTrue();
        }

        @Test
        void extractsUnset() {
            Metadata headers = new Metadata();
            GrpcRequestMetadataTest.this.underTest.headers(headers);
            Assertions.assertThat((boolean)GrpcRequestMetadataTest.this.underTest.supportsFastForward()).isFalse();
        }
    }

    @Nested
    class WhenCatchupingBatch {
        WhenCatchupingBatch() {
        }

        @BeforeEach
        void setup() {
        }

        @Test
        void extracts() {
            Metadata headers = new Metadata();
            headers.put(Headers.CATCHUP_BATCHSIZE, (Object)"127");
            GrpcRequestMetadataTest.this.underTest.headers(headers);
            ((OptionalIntAssert)Assertions.assertThat((OptionalInt)GrpcRequestMetadataTest.this.underTest.catchupBatch()).isPresent()).hasValue(127);
        }

        @Test
        void extractsUnset() {
            Metadata headers = new Metadata();
            GrpcRequestMetadataTest.this.underTest.headers(headers);
            Assertions.assertThat((OptionalInt)GrpcRequestMetadataTest.this.underTest.catchupBatch()).isEmpty();
        }
    }
}

