/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.server.grpc;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import org.assertj.core.api.Assertions;
import org.factcast.core.FactValidationException;
import org.factcast.server.grpc.GrpcServerExceptionInterceptor;
import org.factcast.server.grpc.RequestCanceledByClientException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class GrpcServerExceptionInterceptorTest {
    @InjectMocks
    private GrpcServerExceptionInterceptor underTest;

    GrpcServerExceptionInterceptorTest() {
    }

    @Nested
    class ExceptionHandlingServerCallListenerTests<Req, Res> {
        @Mock
        private ServerCall.Listener<Req> listener;
        @Mock
        private ServerCall<Req, Res> serverCall;
        @Mock
        private Metadata metadata;
        @InjectMocks
        private GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener<Req, Res> underTest;
        private ArrayIndexOutOfBoundsException ex = new ArrayIndexOutOfBoundsException("ignore me");

        ExceptionHandlingServerCallListenerTests() {
        }

        @Nested
        class whenHandlingException {
            whenHandlingException() {
            }

            @Test
            void handlesCancelByClient() {
                GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener uut = (GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener)Mockito.spy(ExceptionHandlingServerCallListenerTests.this.underTest);
                String msg = "123";
                RequestCanceledByClientException ex = new RequestCanceledByClientException(msg);
                uut.handleException((RuntimeException)ex, ExceptionHandlingServerCallListenerTests.this.serverCall, ExceptionHandlingServerCallListenerTests.this.metadata);
                ArgumentCaptor cap = ArgumentCaptor.forClass(Status.class);
                ((ServerCall)Mockito.verify(ExceptionHandlingServerCallListenerTests.this.serverCall)).close((Status)cap.capture(), (Metadata)Mockito.same((Object)ExceptionHandlingServerCallListenerTests.this.metadata));
                Assertions.assertThat((Comparable)((Status)cap.getValue()).getCode()).isEqualTo((Object)Status.Code.CANCELLED);
                Assertions.assertThat((String)((Status)cap.getValue()).getDescription()).isEqualTo(msg);
            }

            @Test
            void closesOnStatusRuntimeException() {
                GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener uut = (GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener)Mockito.spy(ExceptionHandlingServerCallListenerTests.this.underTest);
                String msg = "456";
                StatusRuntimeException ex = new StatusRuntimeException(Status.ALREADY_EXISTS.withDescription(msg));
                uut.handleException((RuntimeException)((Object)ex), ExceptionHandlingServerCallListenerTests.this.serverCall, ExceptionHandlingServerCallListenerTests.this.metadata);
                ArgumentCaptor cap = ArgumentCaptor.forClass(Status.class);
                ((ServerCall)Mockito.verify(ExceptionHandlingServerCallListenerTests.this.serverCall)).close((Status)cap.capture(), (Metadata)Mockito.same((Object)ExceptionHandlingServerCallListenerTests.this.metadata));
                Assertions.assertThat((Comparable)((Status)cap.getValue()).getCode()).isEqualTo((Object)Status.Code.ALREADY_EXISTS);
                Assertions.assertThat((String)((Status)cap.getValue()).getDescription()).isEqualTo(msg);
            }

            @Test
            void closesWithTranslatedException() {
                GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener uut = (GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener)Mockito.spy(ExceptionHandlingServerCallListenerTests.this.underTest);
                String msg = "456";
                FactValidationException ex = new FactValidationException(msg);
                Metadata metadata = new Metadata();
                uut.handleException((RuntimeException)ex, ExceptionHandlingServerCallListenerTests.this.serverCall, metadata);
                ArgumentCaptor cap = ArgumentCaptor.forClass(Metadata.class);
                ((ServerCall)Mockito.verify(ExceptionHandlingServerCallListenerTests.this.serverCall)).close((Status)Mockito.any(), (Metadata)cap.capture());
                Assertions.assertThat((boolean)((Metadata)cap.getValue()).containsKey(Metadata.Key.of((String)"msg-bin", (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER))).isTrue();
                Assertions.assertThat((boolean)((Metadata)cap.getValue()).containsKey(Metadata.Key.of((String)"exc-bin", (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER))).isTrue();
            }
        }

        @Nested
        class onComplete {
            onComplete() {
            }

            @Test
            void handlesException() {
                GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener uut = (GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener)Mockito.spy(ExceptionHandlingServerCallListenerTests.this.underTest);
                ((ServerCall.Listener)Mockito.doThrow((Throwable[])new Throwable[]{ExceptionHandlingServerCallListenerTests.this.ex}).when(ExceptionHandlingServerCallListenerTests.this.listener)).onComplete();
                Object msg = null;
                Assertions.assertThatThrownBy(() -> ((GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener)uut).onComplete()).isInstanceOf(ArrayIndexOutOfBoundsException.class);
                ((GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener)Mockito.verify((Object)uut)).handleException((RuntimeException)Mockito.same((Object)ExceptionHandlingServerCallListenerTests.this.ex), (ServerCall)Mockito.any(), (Metadata)Mockito.any());
            }

            @Test
            void happyPath() {
                ExceptionHandlingServerCallListenerTests.this.underTest.onComplete();
            }
        }

        @Nested
        class onCancel {
            onCancel() {
            }

            @Test
            void handlesException() {
                GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener uut = (GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener)Mockito.spy(ExceptionHandlingServerCallListenerTests.this.underTest);
                ((ServerCall.Listener)Mockito.doThrow((Throwable[])new Throwable[]{ExceptionHandlingServerCallListenerTests.this.ex}).when(ExceptionHandlingServerCallListenerTests.this.listener)).onCancel();
                Object msg = null;
                Assertions.assertThatThrownBy(() -> ((GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener)uut).onCancel()).isInstanceOf(ArrayIndexOutOfBoundsException.class);
                ((GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener)Mockito.verify((Object)uut)).handleException((RuntimeException)Mockito.same((Object)ExceptionHandlingServerCallListenerTests.this.ex), (ServerCall)Mockito.any(), (Metadata)Mockito.any());
            }

            @Test
            void happyPath() {
                ExceptionHandlingServerCallListenerTests.this.underTest.onCancel();
            }
        }

        @Nested
        class onReady {
            onReady() {
            }

            @Test
            void handlesException() {
                GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener uut = (GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener)Mockito.spy(ExceptionHandlingServerCallListenerTests.this.underTest);
                ((ServerCall.Listener)Mockito.doThrow((Throwable[])new Throwable[]{ExceptionHandlingServerCallListenerTests.this.ex}).when(ExceptionHandlingServerCallListenerTests.this.listener)).onReady();
                Object msg = null;
                Assertions.assertThatThrownBy(() -> ((GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener)uut).onReady()).isInstanceOf(ArrayIndexOutOfBoundsException.class);
                ((GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener)Mockito.verify((Object)uut)).handleException((RuntimeException)Mockito.same((Object)ExceptionHandlingServerCallListenerTests.this.ex), (ServerCall)Mockito.any(), (Metadata)Mockito.any());
            }

            @Test
            void happyPath() {
                ExceptionHandlingServerCallListenerTests.this.underTest.onReady();
            }
        }

        @Nested
        class onMessage {
            onMessage() {
            }

            @BeforeEach
            void setup() {
            }

            @Test
            void handlesException() {
                GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener uut = (GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener)Mockito.spy(ExceptionHandlingServerCallListenerTests.this.underTest);
                ((ServerCall.Listener)Mockito.doThrow((Throwable[])new Throwable[]{ExceptionHandlingServerCallListenerTests.this.ex}).when(ExceptionHandlingServerCallListenerTests.this.listener)).onMessage(Mockito.any());
                Object msg = null;
                Assertions.assertThatThrownBy(() -> uut.onMessage(msg)).isInstanceOf(ArrayIndexOutOfBoundsException.class);
                ((GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener)Mockito.verify((Object)uut)).handleException((RuntimeException)Mockito.same((Object)ExceptionHandlingServerCallListenerTests.this.ex), (ServerCall)Mockito.any(), (Metadata)Mockito.any());
            }

            @Test
            void happyPath() {
                ExceptionHandlingServerCallListenerTests.this.underTest.onMessage(null);
            }
        }
    }

    @Nested
    class WhenInterceptingCall<Req, Res> {
        @Mock
        private ServerCall<Req, Res> serverCall;
        @Mock
        private ServerCallHandler<Req, Res> serverCallHandler;

        WhenInterceptingCall() {
        }

        @BeforeEach
        void setup() {
        }

        @Test
        void wraps() {
            Assertions.assertThat((Object)GrpcServerExceptionInterceptorTest.this.underTest.interceptCall(this.serverCall, new Metadata(), this.serverCallHandler)).isInstanceOf(GrpcServerExceptionInterceptor.ExceptionHandlingServerCallListener.class);
        }
    }
}

