/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.server.grpc;

import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.factcast.core.subscription.Subscription;
import org.factcast.core.subscription.SubscriptionRequestTO;
import org.factcast.server.grpc.GrpcObserverAdapter;
import org.factcast.server.grpc.OnCancelHandler;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class OnCancelHandlerTest {
    private static final String CLIENT_ID_PREFIX = "CLIENT_ID_PREFIX";
    @Mock
    @NonNull
    private SubscriptionRequestTO req;
    @Mock
    @NonNull
    private GrpcObserverAdapter observer;

    OnCancelHandlerTest() {
    }

    @Nested
    class WhenRuning {
        @Mock
        private Subscription subscription;
        private OnCancelHandler underTest;

        WhenRuning() {
        }

        @BeforeEach
        void setup() {
            AtomicReference<Subscription> subRef = new AtomicReference<Subscription>(this.subscription);
            this.underTest = (OnCancelHandler)Mockito.spy((Object)new OnCancelHandler("id", OnCancelHandlerTest.this.req, subRef, OnCancelHandlerTest.this.observer));
        }

        @Test
        void closesSubscription() {
            this.underTest.run();
            ((Subscription)Mockito.verify((Object)this.subscription)).close();
        }

        @Test
        void shutsDownObserver() {
            this.underTest.run();
            ((Subscription)Mockito.verify((Object)this.subscription)).close();
            ((GrpcObserverAdapter)Mockito.verify((Object)OnCancelHandlerTest.this.observer)).shutdown();
        }

        @Test
        void shutsDownObserverEvenAfterSubscriptionThrows() {
            ((Subscription)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("ignore")}).when((Object)this.subscription)).close();
            this.underTest.run();
            ((Subscription)Mockito.verify((Object)this.subscription)).close();
            ((GrpcObserverAdapter)Mockito.verify((Object)OnCancelHandlerTest.this.observer)).shutdown();
        }

        @Test
        void survivesEveryoneThrowingExceptions() {
            ((Subscription)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("ignore")}).when((Object)this.subscription)).close();
            ((GrpcObserverAdapter)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("ignore")}).when((Object)OnCancelHandlerTest.this.observer)).shutdown();
            this.underTest.run();
            ((Subscription)Mockito.verify((Object)this.subscription)).close();
            ((GrpcObserverAdapter)Mockito.verify((Object)OnCancelHandlerTest.this.observer)).shutdown();
        }
    }
}

