/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.server.grpc;

import java.io.IOException;
import java.sql.SQLException;
import org.assertj.core.api.Assertions;
import org.factcast.server.grpc.ServerExceptionLogger;
import org.factcast.test.Slf4jHelper;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import slf4jtest.LogLevel;
import slf4jtest.TestLogger;

@ExtendWith(value={MockitoExtension.class})
class ServerExceptionLoggerTest {
    @InjectMocks
    private ServerExceptionLogger underTest;

    ServerExceptionLoggerTest() {
    }

    @Test
    void testError() {
        TestLogger logger = Slf4jHelper.replaceLogger((Object)this.underTest);
        RuntimeException e = new RuntimeException();
        String id = "foo";
        this.underTest.error((Throwable)e, id);
        Assertions.assertThat((int)logger.lines().size()).isEqualTo(1);
        Assertions.assertThat((boolean)logger.lines().stream().anyMatch(l -> l.level == LogLevel.ErrorLevel && l.text.startsWith(id + " onError \u2013 sending Error notification"))).isTrue();
    }

    @Test
    void testWarn() {
        TestLogger logger = Slf4jHelper.replaceLogger((Object)this.underTest);
        RuntimeException e = new RuntimeException();
        String id = "foo";
        this.underTest.warn((Throwable)e, id);
        Assertions.assertThat((int)logger.lines().size()).isEqualTo(1);
        Assertions.assertThat((boolean)logger.lines().stream().anyMatch(l -> l.level == LogLevel.WarnLevel && l.text.startsWith(id + " onError \u2013 sending Error notification"))).isTrue();
    }

    @Test
    void testInfo() {
        TestLogger logger = Slf4jHelper.replaceLogger((Object)this.underTest);
        RuntimeException e = new RuntimeException();
        String id = "foo";
        this.underTest.info((Throwable)e, id);
        Assertions.assertThat((int)logger.lines().size()).isEqualTo(1);
        Assertions.assertThat((boolean)logger.lines().stream().anyMatch(l -> l.level == LogLevel.InfoLevel && l.text.startsWith(id + " onError \u2013 sending Error notification"))).isTrue();
    }

    @Nested
    class WhenLoging {
        @Mock
        private Throwable e;

        WhenLoging() {
        }

        @BeforeEach
        void setup() {
        }

        @Test
        void warnsForCertainExceptionWeWantInTheLog() {
            Assertions.assertThat((Comparable)ServerExceptionLoggerTest.this.underTest.resolveLevelFor((Throwable)new SQLException(""))).isEqualTo((Object)ServerExceptionLogger.Level.WARN);
            Assertions.assertThat((Comparable)ServerExceptionLoggerTest.this.underTest.resolveLevelFor((Throwable)new IllegalStateException(""))).isEqualTo((Object)ServerExceptionLogger.Level.WARN);
            Assertions.assertThat((Comparable)ServerExceptionLoggerTest.this.underTest.resolveLevelFor((Throwable)new IllegalArgumentException(""))).isEqualTo((Object)ServerExceptionLogger.Level.WARN);
            Assertions.assertThat((Comparable)ServerExceptionLoggerTest.this.underTest.resolveLevelFor((Throwable)new UnsupportedOperationException(""))).isEqualTo((Object)ServerExceptionLogger.Level.WARN);
            Assertions.assertThat((Comparable)ServerExceptionLoggerTest.this.underTest.resolveLevelFor((Throwable)new RuntimeException(new SQLException("")))).isEqualTo((Object)ServerExceptionLogger.Level.WARN);
            Assertions.assertThat((Comparable)ServerExceptionLoggerTest.this.underTest.resolveLevelFor((Throwable)new RuntimeException(new RuntimeException(new SQLException(""))))).isEqualTo((Object)ServerExceptionLogger.Level.WARN);
            Assertions.assertThat((Comparable)ServerExceptionLoggerTest.this.underTest.resolveLevelFor((Throwable)new NumberFormatException(""))).isEqualTo((Object)ServerExceptionLogger.Level.WARN);
        }

        @Test
        void logsInfoLevelForUnknownExceptions() {
            Assertions.assertThat((Comparable)ServerExceptionLoggerTest.this.underTest.resolveLevelFor((Throwable)new RuntimeException(""))).isEqualTo((Object)ServerExceptionLogger.Level.INFO);
        }

        @Test
        void skippsLoggingIOException() {
            Assertions.assertThat((Comparable)ServerExceptionLoggerTest.this.underTest.resolveLevelFor((Throwable)new IOException(""))).isEqualTo((Object)ServerExceptionLogger.Level.JUST_SEND_TO_CONSUMER);
        }

        @Test
        void testLog_info() {
            ServerExceptionLogger uut = (ServerExceptionLogger)Mockito.spy((Object)ServerExceptionLoggerTest.this.underTest);
            Exception e = new Exception();
            ((ServerExceptionLogger)Mockito.doReturn((Object)ServerExceptionLogger.Level.INFO).when((Object)uut)).resolveLevelFor((Throwable)e);
            ((ServerExceptionLogger)Mockito.doNothing().when((Object)uut)).info((Throwable)Mockito.any(), (String)Mockito.any());
            uut.log((Throwable)e, "foo");
            ((ServerExceptionLogger)Mockito.verify((Object)uut)).resolveLevelFor((Throwable)e);
            ((ServerExceptionLogger)Mockito.verify((Object)uut)).info((Throwable)e, "foo");
        }

        @Test
        void testLog_warn() {
            ServerExceptionLogger uut = (ServerExceptionLogger)Mockito.spy((Object)ServerExceptionLoggerTest.this.underTest);
            Exception e = new Exception();
            ((ServerExceptionLogger)Mockito.doReturn((Object)ServerExceptionLogger.Level.WARN).when((Object)uut)).resolveLevelFor((Throwable)e);
            ((ServerExceptionLogger)Mockito.doNothing().when((Object)uut)).warn((Throwable)Mockito.any(), (String)Mockito.any());
            uut.log((Throwable)e, "foo");
            ((ServerExceptionLogger)Mockito.verify((Object)uut)).resolveLevelFor((Throwable)e);
            ((ServerExceptionLogger)Mockito.verify((Object)uut)).warn((Throwable)e, "foo");
        }

        @Test
        void testLog_error() {
            ServerExceptionLogger uut = (ServerExceptionLogger)Mockito.spy((Object)ServerExceptionLoggerTest.this.underTest);
            Exception e = new Exception();
            ((ServerExceptionLogger)Mockito.doReturn((Object)ServerExceptionLogger.Level.ERROR).when((Object)uut)).resolveLevelFor((Throwable)e);
            ((ServerExceptionLogger)Mockito.doNothing().when((Object)uut)).error((Throwable)Mockito.any(), (String)Mockito.any());
            uut.log((Throwable)e, "foo");
            ((ServerExceptionLogger)Mockito.verify((Object)uut)).resolveLevelFor((Throwable)e);
            ((ServerExceptionLogger)Mockito.verify((Object)uut)).error((Throwable)e, "foo");
        }

        @Test
        void doesNotLogForJustSendToCLient() {
            ServerExceptionLogger uut = (ServerExceptionLogger)Mockito.spy((Object)ServerExceptionLoggerTest.this.underTest);
            Exception e = new Exception();
            ((ServerExceptionLogger)Mockito.doReturn((Object)ServerExceptionLogger.Level.JUST_SEND_TO_CONSUMER).when((Object)uut)).resolveLevelFor((Throwable)e);
            uut.log((Throwable)e, "foo");
            ((ServerExceptionLogger)Mockito.verify((Object)uut)).log((Throwable)Mockito.any(), (String)Mockito.any());
            ((ServerExceptionLogger)Mockito.verify((Object)uut)).resolveLevelFor((Throwable)e);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{uut});
        }
    }
}

