/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.server.grpc.auth;

import org.factcast.server.grpc.auth.AccessRules;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AccessRulesTest {
    private final AccessRules uut = new AccessRules();

    @Test
    public void testIncludesDefaultsToNull() {
        Assertions.assertNull((Object)this.uut.includes("foo"));
    }

    @Test
    public void testIncludesNegative() {
        this.uut.exclude().add("foo");
        Assertions.assertFalse((boolean)this.uut.includes("foo"));
    }

    @Test
    public void testIncludesNegativeExcludeWins() {
        this.uut.exclude().add("foo");
        this.uut.include().add("foo");
        Assertions.assertFalse((boolean)this.uut.includes("foo"));
    }

    @Test
    public void testIncludesNegativeExcludeWildcardWins() {
        this.uut.exclude().add("*");
        this.uut.include().add("foo");
        Assertions.assertFalse((boolean)this.uut.includes("foo"));
    }

    @Test
    public void testIncludesPositive() {
        this.uut.include().add("foo");
        Assertions.assertTrue((boolean)this.uut.includes("foo"));
    }

    @Test
    public void testIncludesPositiveWildcardStar() {
        this.uut.include().add("*");
        Assertions.assertTrue((boolean)this.uut.includes("foo"));
    }

    @Test
    public void testIncludesPositiveWildcard() {
        this.uut.include().add("fo*");
        Assertions.assertTrue((boolean)this.uut.includes("foo"));
    }
}

