/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.server.grpc.auth;

import org.factcast.server.grpc.auth.FactCastAccessConfiguration;
import org.factcast.server.grpc.auth.FactCastAccount;
import org.factcast.server.grpc.auth.FactCastRole;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class FactCastAccountTest {
    private final FactCastAccount uut = new FactCastAccount("foo");

    @Test
    public void testDefaultsToFalse() {
        this.uut.initialize((FactCastAccessConfiguration)Mockito.mock(FactCastAccessConfiguration.class));
        Assertions.assertFalse((boolean)this.uut.canRead("foo"));
        Assertions.assertFalse((boolean)this.uut.canWrite("foo"));
    }

    @Test
    public void testReadOnly() {
        FactCastRole readOnlyRole = new FactCastRole();
        readOnlyRole.read().include().add("*");
        this.uut.role(new FactCastRole[]{readOnlyRole});
        Assertions.assertTrue((boolean)this.uut.canRead("foo"));
        Assertions.assertFalse((boolean)this.uut.canWrite("foo"));
    }

    @Test
    public void testReadOnlyMultiRole() {
        FactCastRole other = new FactCastRole();
        other.read().exclude().add("toBeExcluded");
        FactCastRole readOnlyRole = new FactCastRole();
        readOnlyRole.read().include().add("*");
        this.uut.role(new FactCastRole[]{other});
        this.uut.role(new FactCastRole[]{readOnlyRole});
        Assertions.assertTrue((boolean)this.uut.canRead("foo"));
        Assertions.assertFalse((boolean)this.uut.canWrite("foo"));
    }

    @Test
    public void testReadOnlyMultiRoleWithConflict() {
        FactCastRole role1 = new FactCastRole();
        role1.read().include().add("foo");
        FactCastRole role2 = new FactCastRole();
        role2.read().exclude().add("foo");
        this.uut.role(new FactCastRole[]{role1, role2});
        Assertions.assertFalse((boolean)this.uut.canRead("foo"));
        Assertions.assertFalse((boolean)this.uut.canWrite("foo"));
    }

    @Test
    public void testInilializationRuns() {
        FactCastRole role1 = new FactCastRole("r1");
        role1.read().include().add("foo");
        FactCastRole role2 = new FactCastRole("r2");
        role2.read().exclude().add("foo");
        this.uut.roleNames().add(role1.id());
        this.uut.roleNames().add(role2.id());
        FactCastAccessConfiguration cfg = new FactCastAccessConfiguration();
        cfg.roles().add(role1);
        cfg.roles().add(role2);
        cfg.accounts().add(this.uut);
        cfg.initialize();
        Assertions.assertTrue((boolean)this.uut.roles().contains(role1));
        Assertions.assertTrue((boolean)this.uut.roles().contains(role2));
    }
}

