/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.server.security.auth;

import org.assertj.core.api.Assertions;
import org.factcast.server.security.auth.AccessRules;
import org.junit.jupiter.api.Test;

class AccessRulesTest {
    private final AccessRules uut = new AccessRules();

    AccessRulesTest() {
    }

    @Test
    void testIncludesDefaultsToNull() {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.uut.includes("foo"));
    }

    @Test
    void testIncludesNegative() {
        this.uut.exclude().add("foo");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.uut.includes("foo"));
    }

    @Test
    void testIncludesNegativeExcludeWins() {
        this.uut.exclude().add("foo");
        this.uut.include().add("foo");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.uut.includes("foo"));
    }

    @Test
    void testIncludesNegativeExcludeWildcardWins() {
        this.uut.exclude().add("*");
        this.uut.include().add("foo");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.uut.includes("foo"));
    }

    @Test
    void testIncludesPositive() {
        this.uut.include().add("foo");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.uut.includes("foo"));
    }

    @Test
    void testIncludesPositiveWildcardStar() {
        this.uut.include().add("*");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.uut.includes("foo"));
    }

    @Test
    void testIncludesPositiveWildcard() {
        this.uut.include().add("fo*");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.uut.includes("foo"));
    }

    @Test
    void testMissesPositiveWildcard() {
        this.uut.include().add("fo*");
        Assertions.assertThat((Boolean)this.uut.includes("bar")).isNull();
    }
}

