/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.server.security.auth;

import org.assertj.core.api.Assertions;
import org.factcast.server.security.auth.FactCastAccessConfiguration;
import org.factcast.server.security.auth.FactCastAccount;
import org.factcast.server.security.auth.FactCastRole;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class FactCastAccountTest {
    private FactCastAccount uut = new FactCastAccount("foo");

    FactCastAccountTest() {
    }

    @Test
    void testDefaultsToFalse() {
        this.uut.initialize((FactCastAccessConfiguration)Mockito.mock(FactCastAccessConfiguration.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.uut.canRead("foo"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.uut.canWrite("foo"));
    }

    @Test
    void testReadOnly() {
        FactCastRole readOnlyRole = new FactCastRole();
        readOnlyRole.read().include().add("*");
        this.uut.role(new FactCastRole[]{readOnlyRole});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.uut.canRead("foo"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.uut.canWrite("foo"));
    }

    @Test
    void testReadOnlyMultiRole() {
        FactCastRole other = new FactCastRole();
        other.read().exclude().add("toBeExcluded");
        FactCastRole readOnlyRole = new FactCastRole();
        readOnlyRole.read().include().add("*");
        this.uut.role(new FactCastRole[]{other});
        this.uut.role(new FactCastRole[]{readOnlyRole});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.uut.canRead("foo"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.uut.canWrite("foo"));
    }

    @Test
    void testReadOnlyMultiRoleWithConflict() {
        FactCastRole role1 = new FactCastRole();
        role1.read().include().add("foo");
        FactCastRole role2 = new FactCastRole();
        role2.read().exclude().add("foo");
        this.uut.role(new FactCastRole[]{role1, role2});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.uut.canRead("foo"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.uut.canWrite("foo"));
    }

    @Test
    void testInilializationRuns() {
        FactCastRole role1 = new FactCastRole("r1");
        role1.read().include().add("foo");
        FactCastRole role2 = new FactCastRole("r2");
        role2.read().exclude().add("foo");
        this.uut.roleNames().add(role1.id());
        this.uut.roleNames().add(role2.id());
        FactCastAccessConfiguration cfg = new FactCastAccessConfiguration();
        cfg.roles().add(role1);
        cfg.roles().add(role2);
        cfg.accounts().add(this.uut);
        cfg.initialize();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.uut.roles().contains(role1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.uut.roles().contains(role2));
    }

    @Test
    void testfailsOnIdNull() {
        this.uut = new FactCastAccount();
        FactCastAccessConfiguration cfg = new FactCastAccessConfiguration();
        cfg.initialize();
        Assertions.assertThatThrownBy(() -> this.uut.initialize(cfg)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void godPower() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FactCastAccount.GOD.canRead("anything"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FactCastAccount.GOD.canWrite("anything"));
    }

    @Test
    void cannotReadUninitialized() {
        FactCastAccount underTest = new FactCastAccount();
        Assertions.assertThatThrownBy(() -> underTest.canRead("foo")).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void cannotWriteUninitialized() {
        FactCastAccount underTest = new FactCastAccount();
        Assertions.assertThatThrownBy(() -> underTest.canWrite("foo")).isInstanceOf(IllegalStateException.class);
    }
}

