/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.server.security.auth;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.factcast.server.security.auth.FactCastAccount;
import org.factcast.server.security.auth.FactCastUser;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.security.core.userdetails.User;

@ExtendWith(value={MockitoExtension.class})
class FactCastUserTest {
    @Mock
    private User user;
    @Mock
    private FactCastAccount account;
    @Spy
    private Map<String, Boolean> readAccess = new HashMap<String, Boolean>();
    @Spy
    private Map<String, Boolean> writeAccess = new HashMap<String, Boolean>();
    private FactCastUser underTest;

    FactCastUserTest() {
    }

    @Nested
    class WhenCheckingIfCanWrite {
        private final String NS = "NS";
        private final String NS_CAN_WRITE = "NSW";

        WhenCheckingIfCanWrite() {
        }

        @BeforeEach
        void setup() {
            Mockito.when((Object)FactCastUserTest.this.account.id()).thenReturn((Object)"abc");
            FactCastUserTest.this.underTest = new FactCastUser(FactCastUserTest.this.account, "secret");
        }

        @Test
        void delegates() {
            Mockito.when((Object)FactCastUserTest.this.account.canWrite("NS")).thenReturn((Object)false);
            Mockito.when((Object)FactCastUserTest.this.account.canWrite("NSW")).thenReturn((Object)true);
            Assertions.assertThat((boolean)FactCastUserTest.this.underTest.canWrite("NS")).isFalse();
            Assertions.assertThat((boolean)FactCastUserTest.this.underTest.canWrite("NSW")).isTrue();
        }

        @Test
        void caches() {
            Mockito.when((Object)FactCastUserTest.this.account.canWrite("NS")).thenReturn((Object)false);
            Assertions.assertThat((boolean)FactCastUserTest.this.underTest.canWrite("NS")).isFalse();
            Assertions.assertThat((boolean)FactCastUserTest.this.underTest.canWrite("NS")).isFalse();
            Assertions.assertThat((boolean)FactCastUserTest.this.underTest.canWrite("NS")).isFalse();
            ((FactCastAccount)Mockito.verify((Object)FactCastUserTest.this.account, (VerificationMode)Mockito.times((int)1))).canWrite("NS");
        }
    }

    @Nested
    class WhenCheckingIfCanRead {
        private final String NS = "NS";
        private final String NS_CAN_READ = "NSR";

        WhenCheckingIfCanRead() {
        }

        @BeforeEach
        void setup() {
            Mockito.when((Object)FactCastUserTest.this.account.id()).thenReturn((Object)"abc");
            FactCastUserTest.this.underTest = new FactCastUser(FactCastUserTest.this.account, "secret");
        }

        @Test
        void delegates() {
            Mockito.when((Object)FactCastUserTest.this.account.canRead("NS")).thenReturn((Object)false);
            Mockito.when((Object)FactCastUserTest.this.account.canRead("NSR")).thenReturn((Object)true);
            Assertions.assertThat((boolean)FactCastUserTest.this.underTest.canRead("NS")).isFalse();
            Assertions.assertThat((boolean)FactCastUserTest.this.underTest.canRead("NSR")).isTrue();
        }

        @Test
        void caches() {
            Mockito.when((Object)FactCastUserTest.this.account.canRead("NS")).thenReturn((Object)false);
            Assertions.assertThat((boolean)FactCastUserTest.this.underTest.canRead("NS")).isFalse();
            Assertions.assertThat((boolean)FactCastUserTest.this.underTest.canRead("NS")).isFalse();
            Assertions.assertThat((boolean)FactCastUserTest.this.underTest.canRead("NS")).isFalse();
            ((FactCastAccount)Mockito.verify((Object)FactCastUserTest.this.account, (VerificationMode)Mockito.times((int)1))).canRead("NS");
        }
    }
}

