/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.testsupport.matchers;

import java.util.LinkedHashSet;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeMatcher;

public class MessageListMessageMatcher
extends TypeSafeMatcher<MessageList> {
    private final Matcher<Message>[] messageMatchers;
    private Description mismatchDescription;

    @SafeVarargs
    public MessageListMessageMatcher(Matcher<Message> ... messageMatchers) {
        this.messageMatchers = messageMatchers;
        this.mismatchDescription = new StringDescription();
    }

    public void describeTo(Description description) {
        boolean first = true;
        description.appendText("a " + MessageList.class.getSimpleName() + " containing ");
        Matcher<Message>[] matcherArray = this.messageMatchers;
        int n = this.messageMatchers.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher<Message> matcher = matcherArray[n2];
            if (!first) {
                description.appendText("\n AND ");
            } else {
                first = false;
            }
            description.appendDescriptionOf(matcher);
            ++n2;
        }
    }

    protected boolean matchesSafely(MessageList messageList) {
        boolean allMatch = true;
        LinkedHashSet messages = new LinkedHashSet(messageList.getMessages());
        this.mismatchDescription = new StringDescription();
        Matcher<Message>[] matcherArray = this.messageMatchers;
        int n = this.messageMatchers.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                Matcher<Message> messageMatcher = matcherArray[n2];
                for (Message message : messages) {
                    if (!messageMatcher.matches((Object)message)) continue;
                    messages.remove(message);
                    break block3;
                }
                if (!this.mismatchDescription.toString().isEmpty()) {
                    this.mismatchDescription.appendText("\n AND ");
                }
                messageMatcher.describeTo(this.mismatchDescription);
                allMatch = false;
            }
            ++n2;
        }
        return allMatch;
    }

    protected void describeMismatchSafely(MessageList item, Description mismatchDescription) {
        mismatchDescription.appendText(this.mismatchDescription.toString());
    }
}

