/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ClassToInstancesMap<T> {
    private final ConcurrentHashMap<Class<? extends T>, List<? extends T>> internalMap = new ConcurrentHashMap();

    public <K extends T> List<K> get(Class<K> key) {
        return this.getInstanceList(key);
    }

    public <K extends T> List<K> put(K value) {
        Class<?> implClass = value.getClass();
        return this.put(implClass, value);
    }

    public <K extends T> List<K> put(Class<K> key, K value) {
        List<K> list = this.getInstanceList(key);
        list.add(value);
        return list;
    }

    public List<T> putWithRuntimeCheck(Class<? extends T> key, T value) {
        if (key.isAssignableFrom(value.getClass())) {
            List<T> list = this.getInstanceList(key);
            list.add(value);
            return list;
        }
        throw new RuntimeException("The value " + value + " is not of type " + key);
    }

    public int size() {
        return this.valuesInternal().size();
    }

    public <K extends T> int size(Class<K> key) {
        return this.getInstanceList(key).size();
    }

    public boolean isEmpty() {
        return this.valuesInternal().isEmpty();
    }

    public boolean containsValue(Object value) {
        for (List<T> list : this.internalMap.values()) {
            if (!list.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValuesOf(Class<? extends T> type) {
        return this.internalMap.get(type) != null;
    }

    public boolean remove(Class<? extends T> key, T object) {
        List<T> instanceList = this.getInstanceList(key);
        return instanceList.remove(object);
    }

    public synchronized <K extends T> List<K> removeAll(Class<K> key) {
        List<K> list = this.getInstanceList(key);
        ArrayList<K> result = new ArrayList<K>(list);
        list.clear();
        return result;
    }

    public void clear() {
        this.internalMap.clear();
    }

    private List<T> valuesInternal() {
        ArrayList<? extends T> result = new ArrayList<T>();
        for (List<? extends T> list : this.internalMap.values()) {
            result.addAll(list);
        }
        return result;
    }

    public List<T> values() {
        ArrayList result = new ArrayList();
        Set keySet = this.internalMap.keySet();
        ArrayList sortedKeySet = new ArrayList(keySet);
        Collections.sort(sortedKeySet, Comparator.comparing(Class::getName));
        for (Class key : sortedKeySet) {
            result.addAll(this.internalMap.get(key));
        }
        return result;
    }

    private <K extends T> List<K> getInstanceList(Class<K> key) {
        return this.internalMap.computeIfAbsent(key, $ -> new ArrayList());
    }
}

