/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MultiMap<K, V>
implements Serializable {
    private static final long serialVersionUID = -1167623033749612550L;
    private final CollectionFactory<V> collectionFactory;
    private final ConcurrentHashMap<K, Collection<V>> internalMap;

    public MultiMap() {
        this(new ArrayListFactory());
    }

    public MultiMap(CollectionFactory<V> collectionFactory) {
        this.collectionFactory = collectionFactory;
        this.internalMap = new ConcurrentHashMap(16, 0.75f, 1);
    }

    public static <K, V> MultiMap<K, V> createWithSetsAsValues() {
        return new MultiMap(new HashSetFactory());
    }

    public static <K, V> MultiMap<K, V> createWithListsAsValues() {
        return new MultiMap(new ArrayListFactory());
    }

    public static <K, V> MultiMap<K, V> createWithLinkedSetAsValues() {
        return new MultiMap(new LinkedHashSetFactory());
    }

    @SafeVarargs
    public final void put(K key, V ... values) {
        Collection<V> collection = this.getCollectionInternal(key);
        collection.addAll(Arrays.asList(values));
    }

    public void put(K key, Collection<V> values) {
        Collection<V> collection = this.getCollectionInternal(key);
        collection.addAll(values);
    }

    public void merge(MultiMap<K, V> otherMultiMap) {
        for (Map.Entry<K, Collection<V>> entry : otherMultiMap.internalMap.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putReplace(K key, Collection<V> values) {
        Collection<V> newCollection = this.collectionFactory.createCollection();
        newCollection.addAll(values);
        this.internalMap.put(key, newCollection);
    }

    private Collection<V> getCollectionInternal(K key) {
        Collection<V> collection = this.internalMap.get(key);
        if (collection == null) {
            return this.createNewValue(key);
        }
        return collection;
    }

    private Collection<V> createNewValue(K key) {
        Collection<V> collection = this.collectionFactory.createCollection();
        Collection<V> exitingValue = this.internalMap.putIfAbsent(key, collection);
        if (exitingValue != null) {
            return exitingValue;
        }
        return collection;
    }

    public void remove(Object key, Object value) {
        Collection<V> collection = this.internalMap.get(key);
        if (collection != null) {
            collection.remove(value);
        }
    }

    public Collection<V> remove(Object key) {
        Collection<V> removedCollection = this.internalMap.remove(key);
        if (removedCollection != null) {
            return removedCollection;
        }
        return Collections.emptyList();
    }

    public Collection<V> get(Object key) {
        Collection<V> collection = this.internalMap.get(key);
        if (collection == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(collection);
    }

    public Set<K> keySet() {
        return this.internalMap.keySet();
    }

    public Collection<V> values() {
        Collection<V> collection = this.collectionFactory.createCollection();
        for (Collection<V> value : this.internalMap.values()) {
            collection.addAll(value);
        }
        return collection;
    }

    public int count() {
        int count = 0;
        for (Collection<V> collection : this.internalMap.values()) {
            count += collection.size();
        }
        return count;
    }

    public void clear() {
        this.internalMap.clear();
    }

    public static class ArrayListFactory<V>
    implements CollectionFactory<V> {
        private static final long serialVersionUID = -1282726028020257888L;

        @Override
        public Collection<V> createCollection() {
            return new ArrayList();
        }
    }

    public static interface CollectionFactory<V>
    extends Serializable {
        public Collection<V> createCollection();
    }

    public static class HashSetFactory<V>
    implements CollectionFactory<V> {
        private static final long serialVersionUID = 2534395916683559784L;

        @Override
        public Collection<V> createCollection() {
            return new HashSet();
        }
    }

    public static class LinkedHashSetFactory<V>
    implements CollectionFactory<V> {
        private static final long serialVersionUID = 2534395916683559784L;

        @Override
        public Collection<V> createCollection() {
            return new LinkedHashSet();
        }
    }
}

