/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.faktorips.annotation.UtilityClass;
import org.faktorips.util.IoUtil;

@UtilityClass
public class StreamUtil {
    private StreamUtil() {
    }

    public static final ByteArrayInputStream copy(InputStream is) throws IOException {
        ByteArrayOutputStream buffer = StreamUtil.toByteArrayOutputStream(is);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer == null ? new byte[]{} : buffer.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            IoUtil.close(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ByteArrayOutputStream toByteArrayOutputStream(InputStream is) throws IOException {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            int nRead;
            byte[] data = new byte[1024];
            while ((nRead = is.read(data)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
        }
        finally {
            is.close();
        }
        return buffer;
    }
}

