/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.util.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

public class DistinctElementComparator<T>
implements Comparator<Collection<T>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Comparator<T> elementComparator;

    public DistinctElementComparator(Comparator<T> elementComparator) {
        this.elementComparator = elementComparator;
    }

    public static <T> DistinctElementComparator<T> createComparator(Comparator<T> elementComparator) {
        return new DistinctElementComparator<T>(elementComparator);
    }

    @Override
    public int compare(Collection<T> o1, Collection<T> o2) {
        TreeSet<T> sorted1 = new TreeSet<T>(this.elementComparator);
        sorted1.addAll(o1);
        TreeSet<T> sorted2 = new TreeSet<T>(this.elementComparator);
        sorted2.addAll(o2);
        Iterator<T> iterator2 = sorted2.iterator();
        Iterator<T> iterator1 = sorted1.iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            int compareValue = this.elementComparator.compare(iterator1.next(), iterator2.next());
            if (compareValue == 0) continue;
            return compareValue;
        }
        return Integer.compare(sorted1.size(), sorted2.size());
    }
}

