/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.client;

import java.io.IOException;
import org.filesys.client.DiskSession;
import org.filesys.client.SMBPacket;
import org.filesys.client.SearchContext;
import org.filesys.client.info.FileInfo;
import org.filesys.smb.PCShare;
import org.filesys.smb.SMBException;
import org.filesys.util.DataPacker;

class CoreSearchContext
extends SearchContext {
    private static final int DirResumeLength = 21;
    private static final int DirAttrLength = 1;
    private static final int DirDateLength = 2;
    private static final int DirTimeLength = 2;
    private static final int DirSizeLength = 4;
    private static final int DirNameLength = 13;
    private static final int DirNameOffset = 30;
    private static final int DirInfoLen = 43;
    private SMBPacket m_pkt = null;
    private int m_dirIdx;

    protected CoreSearchContext(DiskSession sess) {
        super(sess);
    }

    protected boolean ContinueSearch() throws IOException, SMBException {
        int pos = this.m_pkt.getByteOffset() + 2;
        byte[] buf = this.m_pkt.getBuffer();
        buf[pos++] = 4;
        buf[pos++] = 0;
        buf[pos++] = 5;
        DataPacker.putIntelShort(21, buf, pos);
        pos += 2;
        int respos = this.getDirEntryOffset(this.getDirEntryCount() - 1);
        for (int i = 0; i < 21; ++i) {
            buf[pos++] = buf[respos++];
        }
        buf[pos++] = 0;
        DataPacker.putIntelShort(27, buf, this.m_pkt.getByteOffset());
        this.m_pkt.setParameterCount(2);
        this.m_pkt.setParameter(0, 50);
        this.m_pkt.setParameter(1, this.getSearchAttributes());
        this.m_pkt.setFlags(0);
        this.m_pkt.ExchangeSMB(this.getSession(), this.m_pkt);
        if (!this.m_pkt.isValidResponse()) {
            if (this.m_pkt.getErrorClass() == 1 && this.m_pkt.getErrorCode() == 18) {
                return false;
            }
            throw new IOException("Continue search failed");
        }
        this.m_dirIdx = 0;
        return true;
    }

    private int getDirEntryCount() {
        return this.m_pkt.getParameter(0);
    }

    private int getDirEntryOffset(int idx) {
        int pos = this.m_pkt.getByteOffset() + 3;
        return pos += idx * 43;
    }

    @Override
    public FileInfo nextFileInfo() throws IOException, SMBException {
        int fnamelen;
        if (this.m_dirIdx >= this.getDirEntryCount() && !this.ContinueSearch()) {
            return null;
        }
        int pos = this.getDirEntryOffset(this.m_dirIdx++) + 21;
        byte[] buf = this.m_pkt.getBuffer();
        byte attr = buf[pos++];
        int wrtime = DataPacker.getIntelShort(buf, pos);
        int wrdate = DataPacker.getIntelShort(buf, pos += 2);
        int fsize = DataPacker.getIntelInt(buf, pos += 2);
        pos += 4;
        for (fnamelen = 0; fnamelen < 13 && buf[pos + fnamelen] != 0; ++fnamelen) {
        }
        String fname = new String(buf, pos, fnamelen);
        return new FileInfo(fname, fsize, attr, wrdate, wrtime);
    }

    @Override
    public String nextFileName() throws IOException, SMBException {
        int fnamelen;
        if (this.m_dirIdx >= this.getDirEntryCount() && !this.ContinueSearch()) {
            return null;
        }
        int pos = this.getDirEntryOffset(this.m_dirIdx++) + 30;
        byte[] buf = this.m_pkt.getBuffer();
        for (fnamelen = 0; fnamelen < 13 && buf[pos + fnamelen] != 0; ++fnamelen) {
        }
        return new String(buf, pos, fnamelen);
    }

    @Override
    public final void StartSearch(String fname, int attr, int level) throws IOException, SMBException {
        this.setSearchParameters(fname, attr, level);
        if (this.m_pkt == null) {
            this.m_pkt = new SMBPacket();
            this.m_pkt.setCommand(129);
            this.m_pkt.setUserId(this.getSession().getUserId());
            this.m_pkt.setTreeId(this.getSession().getTreeId());
        }
        this.m_pkt.setFlags(this.getSession().getDefaultFlags());
        this.m_pkt.setFlags2(this.getSession().getDefaultFlags2());
        this.m_pkt.setParameterCount(2);
        this.m_pkt.setParameter(0, 50);
        this.m_pkt.setParameter(1, this.getSearchAttributes());
        String searchPath = this.getSearchPath();
        if (!searchPath.startsWith("\\")) {
            searchPath = PCShare.makePath(this.getSession().getWorkingDirectory(), this.getSearchPath());
        }
        this.m_pkt.resetBytePointer();
        this.m_pkt.packByte(4);
        this.m_pkt.packString(searchPath, false);
        this.m_pkt.packByte(5);
        this.m_pkt.packWord(0);
        this.m_pkt.setByteCount();
        this.m_pkt.ExchangeSMB(this.getSession(), this.m_pkt);
        if (!this.m_pkt.isValidResponse()) {
            throw new IOException("Search failed");
        }
        this.m_dirIdx = 0;
    }
}

