/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.client;

import java.io.IOException;
import org.filesys.client.SMBPacket;
import org.filesys.client.Session;
import org.filesys.debug.Debug;
import org.filesys.smb.SMBException;
import org.filesys.smb.TransactBuffer;
import org.filesys.util.DataBuffer;
import org.filesys.util.DataPacker;

public class NTTransPacket
extends SMBPacket {
    private static final int StandardParams = 19;
    private static final int ParameterBytes = 36;
    private static final int NTMaxSetupCount = 37;
    private static final int NTParams = 40;
    private static final int NTSetupCount = 72;
    private static final int NTFunction = 73;
    private static final int DefaultReturnParams = 4;
    private static final int DefaultReturnData = 1024;

    public NTTransPacket() {
    }

    public NTTransPacket(byte[] buf) {
        super(buf);
    }

    public final int getDataLength() {
        return this.getNTParameter(6);
    }

    public final int getDataOffset() {
        return this.getNTParameter(7) + 4;
    }

    public final int[] getParameterBlock() {
        int prmcnt = this.getParameterBlockCount() / 4;
        if (prmcnt <= 0) {
            return null;
        }
        int[] prmblk = new int[prmcnt];
        int pos = this.getParameterBlockOffset();
        this.setBytePointer(pos, this.getByteCount());
        for (int idx = 0; idx < prmcnt; ++idx) {
            prmblk[idx] = this.unpackInt();
        }
        if (Session.hasDebugOption(2)) {
            Debug.println("NT Transaction parameter dump - " + prmcnt + " params :-");
            for (int i = 0; i < prmcnt; ++i) {
                Debug.println(" " + i + ". = " + prmblk[i] + ", 0x" + Integer.toHexString(prmblk[i]));
            }
        }
        return prmblk;
    }

    public final int getTotalParameterCount() {
        return this.getNTParameter(0);
    }

    public final int getTotalDataCount() {
        return this.getNTParameter(1);
    }

    public final int getParameterBlockCount() {
        return this.getNTParameter(2);
    }

    public final int getParameterBlockOffset() {
        return this.getNTParameter(3) + 4;
    }

    public final int getParameterBlockDisplacement() {
        return this.getNTParameter(4);
    }

    public final int getDataBlockCount() {
        return this.getNTParameter(5);
    }

    public final int getDataBlockOffset() {
        return this.getNTParameter(6) + 4;
    }

    public final int getDataBlockDisplacement() {
        return this.getNTParameter(7);
    }

    public final void InitializeNTTransact(int func, byte[] paramblk, int plen, byte[] datablk, int dlen, int setupcnt) {
        this.InitializeNTTransact(func, paramblk, plen, datablk, dlen, setupcnt, 4, 1024);
    }

    public final void InitializeNTTransact(int func, byte[] paramblk, int plen, byte[] datablk, int dlen, int setupcnt, int maxPrm, int maxData) {
        this.setCommand(160);
        this.setParameterCount(19 + setupcnt);
        this.setTotalParameterCount(plen);
        this.setTotalDataCount(dlen);
        this.setMaximumParameterReturn(maxPrm);
        this.setMaximumDataReturn(maxData);
        this.setNTParameterCount(plen);
        this.setParameterBlockOffset(0);
        this.setDataBlockCount(dlen);
        this.setDataBlockOffset(0);
        this.setSetupCount(setupcnt);
        this.setNTFunction(func);
        this.resetBytePointerAlign();
        if (paramblk != null) {
            this.setParameterBlockOffset(this.getPosition());
            this.packBytes(paramblk, plen);
        }
        if (datablk != null) {
            this.alignBytePointer();
            this.setDataBlockOffset(this.getPosition());
            this.packBytes(datablk, dlen);
        }
        this.setByteCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TransactBuffer doTransaction(Session sess, TransactBuffer tbuf) throws IOException, SMBException {
        int mid = sess.getNextMultiplexId();
        this.setCommand(160);
        this.setFlags(sess.getDefaultFlags());
        this.setFlags2(sess.getDefaultFlags2());
        this.setMultiplexId(mid);
        this.setTreeId(sess.getTreeId());
        this.setUserId(sess.getUserId());
        tbuf.setEndOfBuffer();
        DataBuffer setupBuf = tbuf.getSetupBuffer();
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        DataBuffer dataBuf = tbuf.getDataBuffer();
        if (tbuf.hasSetupBuffer()) {
            this.setParameterCount(19 + setupBuf.getLengthInWords());
        } else {
            this.setParameterCount(19);
        }
        int totParamLen = paramBuf != null ? paramBuf.getLength() : 0;
        int totDataLen = dataBuf != null ? dataBuf.getLength() : 0;
        this.setTotalParameterCount(totParamLen);
        this.setTotalDataCount(totDataLen);
        this.setMaximumParameterReturn(tbuf.getReturnParameterLimit());
        this.setMaximumDataReturn(tbuf.getReturnDataLimit());
        int availBuf = this.getAvailableLength();
        int plen = totParamLen;
        int dlen = totDataLen;
        if (plen + dlen > availBuf) {
            if (plen > 0) {
                if (plen <= availBuf) {
                    if (dlen > 0) {
                        dlen = availBuf - plen;
                    }
                } else {
                    dlen = plen = availBuf / 2;
                }
            } else if (dlen > availBuf) {
                dlen = availBuf;
            }
        }
        this.setNTParameterCount(plen);
        this.setParameterBlockOffset(0);
        this.setDataBlockCount(dlen);
        this.setDataBlockOffset(0);
        this.setSetupCount(setupBuf != null ? setupBuf.getLengthInWords() : 0);
        this.setNTFunction(tbuf.getFunction());
        if (setupBuf != null) {
            setupBuf.copyData(this.getBuffer(), this.getSetupOffset());
        }
        this.resetBytePointerAlign();
        int pos = this.getPosition();
        this.setParameterBlockOffset(pos);
        int packLen = -1;
        if (paramBuf != null) {
            packLen = paramBuf.copyData(this.getBuffer(), pos, plen);
            pos = DataPacker.wordAlign(pos + packLen);
            this.setPosition(pos);
        }
        this.setDataBlockOffset(pos);
        if (dataBuf != null) {
            packLen = dataBuf.copyData(this.getBuffer(), pos, dlen);
            this.setPosition(pos + packLen);
        }
        this.setByteCount();
        TransactBuffer respBuf = null;
        try {
            sess.setTransactionMID(mid);
            this.SendSMB(sess);
            if (paramBuf != null && paramBuf.getAvailableLength() > 0 || dataBuf != null && dataBuf.getAvailableLength() > 0) {
                this.ReceiveSMB(sess);
            }
            availBuf = this.getAvailableLength();
            while (paramBuf != null && paramBuf.getAvailableLength() > 0 || dataBuf != null && dataBuf.getAvailableLength() > 0) {
                this.setCommand(161);
                this.setFlags(sess.getDefaultFlags());
                this.setFlags2(sess.getDefaultFlags2());
                this.setNTParameterCount(18);
                this.setTotalParameterCount(totParamLen);
                this.setTotalDataCount(totDataLen);
                this.setMultiplexId(sess.getNextMultiplexId());
                plen = paramBuf != null ? paramBuf.getAvailableLength() : 0;
                int n = dlen = dataBuf != null ? dataBuf.getAvailableLength() : 0;
                if (plen + dlen > availBuf) {
                    if (plen > 0) {
                        if (plen <= availBuf) {
                            if (dlen > 0) {
                                dlen = availBuf - plen;
                            }
                        } else {
                            dlen = plen = availBuf / 2;
                        }
                    } else if (dlen > availBuf) {
                        dlen = availBuf;
                    }
                }
                this.resetBytePointerAlign();
                packLen = -1;
                pos = this.getPosition();
                if (plen > 0 && paramBuf != null) {
                    this.setParameterBlockOffset(pos);
                    packLen = paramBuf.copyData(this.getBuffer(), pos, plen);
                    pos = DataPacker.wordAlign(pos + packLen);
                    this.setPosition(pos);
                }
                if (dlen > 0 && dataBuf != null) {
                    this.setDataBlockOffset(pos);
                    packLen = dataBuf.copyData(this.getBuffer(), pos, dlen);
                    this.setPosition(pos + packLen);
                }
                this.setByteCount();
                this.SendSMB(sess);
            }
            this.setCommand(160);
            this.ReceiveSMB(sess, false);
            if (!this.isValidResponse()) {
                this.checkForError();
            }
            totParamLen = this.getTotalParameterCount();
            totDataLen = this.getTotalDataCount();
            int setupLen = this.getSetupCount() * 2;
            respBuf = new TransactBuffer(setupLen, totParamLen, totDataLen);
            setupBuf = respBuf.getSetupBuffer();
            paramBuf = respBuf.getParameterBuffer();
            dataBuf = respBuf.getDataBuffer();
            if (setupLen > 0) {
                setupBuf.appendData(this.getBuffer(), this.getSetupOffset(), setupLen);
            }
            while (paramBuf != null && paramBuf.getLength() < totParamLen || dataBuf != null && dataBuf.getLength() < totDataLen) {
                plen = this.getParameterBlockCount();
                if (plen > 0 && paramBuf != null) {
                    paramBuf.appendData(this.getBuffer(), this.getParameterBlockOffset(), plen);
                }
                if ((dlen = this.getDataBlockCount()) > 0 && dataBuf != null) {
                    dataBuf.appendData(this.getBuffer(), this.getDataBlockOffset(), dlen);
                }
                if ((paramBuf == null || paramBuf.getLength() >= totParamLen) && (dataBuf == null || dataBuf.getLength() >= totDataLen)) continue;
                this.ReceiveSMB(sess, false);
                if (!this.isValidResponse()) {
                    this.checkForError();
                }
                totParamLen = this.getTotalParameterCount();
                totDataLen = this.getTotalDataCount();
            }
            if (respBuf != null) {
                respBuf.setEndOfBuffer();
            }
        }
        finally {
            sess.setTransactionMID(-1);
        }
        return respBuf;
    }

    public final void setTotalParameterCount(int cnt) {
        this.setNTParameter(0, cnt);
    }

    public final void setTotalDataCount(int cnt) {
        this.setNTParameter(1, cnt);
    }

    public final void setMaximumParameterReturn(int cnt) {
        this.setNTParameter(2, cnt);
    }

    public final void setMaximumDataReturn(int cnt) {
        this.setNTParameter(3, cnt);
    }

    public final void setNTParameterCount(int cnt) {
        this.setNTParameter(4, cnt);
    }

    public final void setParameterBlockOffset(int off) {
        this.setNTParameter(5, off != 0 ? off - 4 : 0);
    }

    public final void setDataBlockCount(int cnt) {
        this.setNTParameter(6, cnt);
    }

    public final void setDataBlockOffset(int off) {
        this.setNTParameter(7, off != 0 ? off - 4 : 0);
    }

    private final int getNTParameter(int idx) {
        int pos = 40 + 4 * idx;
        return DataPacker.getIntelInt(this.getBuffer(), pos);
    }

    public final int getSetupCount() {
        byte[] buf = this.getBuffer();
        return buf[72] & 0xFF;
    }

    public final int getSetupOffset() {
        return 75;
    }

    public final int getNTFunction() {
        byte[] buf = this.getBuffer();
        return DataPacker.getIntelShort(buf, 73);
    }

    private final void setNTParameter(int idx, int val) {
        int pos = 40 + 4 * idx;
        DataPacker.putIntelInt(val, this.getBuffer(), pos);
    }

    public final void setMaximumSetupCount(int cnt) {
        byte[] buf = this.getBuffer();
        buf[37] = (byte)cnt;
    }

    public final void setSetupCount(int cnt) {
        byte[] buf = this.getBuffer();
        buf[72] = (byte)cnt;
    }

    public final void setNTFunction(int func) {
        byte[] buf = this.getBuffer();
        DataPacker.putIntelShort(func, buf, 73);
    }

    public final void resetSetupPointer() {
        this.m_endpos = this.m_pos = 75;
    }

    public final void resetDataBlockPointer() {
        this.m_endpos = this.m_pos = this.getDataBlockOffset();
    }

    public final void resetParameterBlockPointer() {
        this.m_endpos = this.m_pos = this.getParameterBlockOffset();
    }
}

