/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.client;

import java.io.IOException;
import org.filesys.client.DiskSession;
import org.filesys.client.SearchContext;
import org.filesys.client.TransPacket;
import org.filesys.client.info.FileInfo;
import org.filesys.client.info.ReparsePointFileInfo;
import org.filesys.server.filesys.FileAttribute;
import org.filesys.smb.NTTime;
import org.filesys.smb.PCShare;
import org.filesys.smb.SMBException;
import org.filesys.smb.TransactBuffer;
import org.filesys.util.DataBuffer;

class TransSearchContext
extends SearchContext {
    protected static final int PacketSize = 16500;
    protected static final int EntriesPerPacket = 1200;
    protected static final int FlgCloseSearch = 1;
    protected static final int FlgCloseAtEnd = 2;
    protected static final int FlgReturnResumeKey = 4;
    protected static final int FlgResumePrevious = 8;
    protected static final int FlgBackupIntent = 16;
    protected static final int ResumeKeyLen = 4;
    protected static final int StdCreateDate = 4;
    protected static final int StdCreateTime = 6;
    protected static final int StdAccessDate = 8;
    protected static final int StdAccessTime = 10;
    protected static final int StdWriteDate = 12;
    protected static final int StdWriteTime = 14;
    protected static final int StdFileSize = 16;
    protected static final int StdAllocSize = 20;
    protected static final int StdAttributes = 24;
    protected static final int StdNameLength = 26;
    protected static final int StdFileName = 27;
    private TransPacket m_pkt;
    private TransactBuffer m_tbuf;
    private TransactBuffer m_rxtbuf;
    private DataBuffer m_dbuf;
    private int m_searchId;
    private String m_resumeName;
    private int m_dirIdx;
    private int m_maxIdx;
    private boolean m_eof;

    protected TransSearchContext(DiskSession sess) {
        super(sess);
    }

    protected boolean ContinueSearch() throws IOException, SMBException {
        if (this.m_eof) {
            return false;
        }
        this.m_tbuf.setFunction(2);
        DataBuffer paramBuf = this.m_tbuf.getParameterBuffer();
        paramBuf.setPosition(0);
        paramBuf.putShort(this.m_searchId);
        paramBuf.putShort(1200);
        paramBuf.putShort(this.getInformationLevel());
        paramBuf.putInt(0);
        paramBuf.putShort(12);
        if (this.m_resumeName != null) {
            paramBuf.putString(this.m_resumeName, this.getSession().isUnicode());
        }
        this.m_rxtbuf = this.m_pkt.doTransaction(this.getSession(), this.m_tbuf);
        if (this.m_rxtbuf != null && this.m_rxtbuf.hasParameterBuffer()) {
            paramBuf = this.m_rxtbuf.getParameterBuffer();
            this.m_dirIdx = 0;
            this.m_maxIdx = paramBuf.getShortAt(0);
            this.m_dbuf = this.m_rxtbuf.getDataBuffer();
            this.m_eof = paramBuf.getShortAt(1) != 0;
            return this.m_dbuf != null;
        }
        return false;
    }

    @Override
    public final FileInfo nextFileInfo() throws IOException, SMBException {
        if (this.m_dirIdx == this.m_maxIdx && !this.ContinueSearch()) {
            return null;
        }
        FileInfo finfo = null;
        switch (this.getInformationLevel()) {
            case 1: {
                finfo = this.unpackStandardInfo(false);
                break;
            }
            case 2: {
                finfo = this.unpackStandardInfo(true);
                break;
            }
            case 257: {
                finfo = this.unpackFileDirectoryInfo();
                break;
            }
            case 258: {
                finfo = this.unpackFileDirectoryInfo();
                break;
            }
            case 260: {
                finfo = this.unpackFileDirectoryInfo();
                break;
            }
            case 259: {
                finfo = this.unpackFileNameInfo();
            }
        }
        if (finfo != null) {
            this.m_resumeName = finfo.getFileName();
        }
        return finfo;
    }

    @Override
    public final String nextFileName() throws IOException, SMBException {
        if (this.m_dirIdx == this.m_maxIdx && !this.ContinueSearch()) {
            return null;
        }
        String fname = null;
        FileInfo finfo = null;
        switch (this.getInformationLevel()) {
            case 1: {
                fname = this.unpackStandardName();
                break;
            }
            case 257: {
                finfo = this.unpackFileDirectoryInfo();
                if (finfo == null) break;
                fname = finfo.getFileName();
                break;
            }
            case 258: {
                finfo = this.unpackFileDirectoryInfo();
                if (finfo == null) break;
                fname = finfo.getFileName();
                break;
            }
            case 260: {
                finfo = this.unpackFileDirectoryInfo();
                if (finfo == null) break;
                fname = finfo.getFileName();
                break;
            }
            case 259: {
                finfo = this.unpackFileNameInfo();
                if (finfo == null) break;
                fname = finfo.getFileName();
            }
        }
        if (fname != null) {
            this.m_resumeName = fname;
        }
        return fname;
    }

    @Override
    public final void StartSearch(String fname, int attr, int level) throws IOException, SMBException {
        this.setSearchParameters(fname, attr, level);
        if (this.m_pkt == null) {
            this.m_pkt = new TransPacket(16500);
        }
        if (this.m_tbuf == null) {
            this.m_tbuf = new TransactBuffer(1, null, 0, 512, 65000);
        } else {
            this.m_tbuf.setFunction(1);
            this.m_tbuf.getParameterBuffer().setPosition(0);
        }
        String searchPath = this.getSearchPath();
        if (!searchPath.startsWith("\\")) {
            searchPath = PCShare.makePath(this.getSession().getWorkingDirectory(), this.getSearchPath());
        }
        DataBuffer paramBuf = this.m_tbuf.getParameterBuffer();
        paramBuf.putShort(this.getSearchAttributes());
        paramBuf.putShort(1200);
        paramBuf.putShort(6);
        paramBuf.putShort(this.getInformationLevel());
        paramBuf.putInt(0);
        paramBuf.putString(fname, this.getSession().isUnicode());
        try {
            this.m_rxtbuf = this.m_pkt.doTransaction(this.getSession(), this.m_tbuf);
        }
        catch (IOException ex) {
            this.m_eof = true;
            this.m_maxIdx = 0;
            this.m_dirIdx = 0;
            throw ex;
        }
        if (this.m_rxtbuf != null && this.m_rxtbuf.hasParameterBuffer()) {
            paramBuf = this.m_rxtbuf.getParameterBuffer();
            this.m_searchId = paramBuf.getShortAt(0);
            this.m_dirIdx = 0;
            this.m_maxIdx = paramBuf.getShortAt(1);
            this.m_dbuf = this.m_rxtbuf.getDataBuffer();
            this.m_eof = paramBuf.getShortAt(2) != 0;
        }
    }

    private final FileInfo unpackStandardInfo(boolean eaSize) {
        int resKey = this.m_dbuf.getInt();
        int crdate = this.m_dbuf.getShort();
        int crtime = this.m_dbuf.getShort();
        int acdate = this.m_dbuf.getShort();
        int actime = this.m_dbuf.getShort();
        int wrdate = this.m_dbuf.getShort();
        int wrtime = this.m_dbuf.getShort();
        int fsize = this.m_dbuf.getInt();
        int alloc = this.m_dbuf.getInt();
        int attr = this.m_dbuf.getShort();
        if (eaSize) {
            this.m_dbuf.getInt();
        }
        int bytlen = this.m_dbuf.getByte();
        int fnamelen = bytlen++;
        if (this.m_rxtbuf.isUnicode()) {
            fnamelen = bytlen / 2;
            bytlen += 2;
            this.m_dbuf.wordAlign();
        }
        String fname = this.m_dbuf.getString(fnamelen, this.m_rxtbuf.isUnicode());
        ++this.m_dirIdx;
        return new FileInfo(fname, fsize, attr, wrdate, wrtime);
    }

    private final String unpackStandardName() {
        int nextOff = this.m_dbuf.getInt();
        this.m_dbuf.skipBytes(22);
        int bytlen = this.m_dbuf.getByte();
        int fnamelen = bytlen++;
        if (this.m_rxtbuf.isUnicode()) {
            this.m_dbuf.wordAlign();
            fnamelen = bytlen / 2;
            bytlen += 2;
        }
        ++this.m_dirIdx;
        if (this.m_dirIdx < this.m_maxIdx) {
            this.m_dbuf.setPosition(nextOff);
        }
        return this.m_dbuf.getString(fnamelen, this.m_rxtbuf.isUnicode());
    }

    private final FileInfo unpackFileDirectoryInfo() {
        int startPos = this.m_dbuf.getPosition();
        int nextOff = this.m_dbuf.getInt();
        int fid = this.m_dbuf.getInt();
        long createTime = this.m_dbuf.getLong();
        long accessTime = this.m_dbuf.getLong();
        long writeTime = this.m_dbuf.getLong();
        long changeTime = this.m_dbuf.getLong();
        long fileSize = this.m_dbuf.getLong();
        long allocSize = this.m_dbuf.getLong();
        int attrib = this.m_dbuf.getInt();
        int nameLen = this.m_dbuf.getInt();
        int eaSize = 0;
        if (this.getInformationLevel() == 258 || this.getInformationLevel() == 260) {
            eaSize = this.m_dbuf.getInt();
        }
        String shortName = null;
        if (this.getInformationLevel() == 260) {
            int shortLen = this.m_dbuf.getByte();
            this.m_dbuf.skipBytes(1);
            int shortPos = this.m_dbuf.getPosition();
            if (shortLen > 0) {
                shortName = this.m_dbuf.getString(shortLen / 2, true);
            }
            this.m_dbuf.setPosition(shortPos + 24);
        }
        if (this.m_rxtbuf.isUnicode()) {
            nameLen /= 2;
        }
        String fileName = this.m_dbuf.getString(nameLen, this.m_rxtbuf.isUnicode());
        FileInfo finfo = null;
        finfo = FileAttribute.hasAttribute(attrib, 1024) ? new ReparsePointFileInfo(fileName, fileSize, attrib, eaSize) : new FileInfo(fileName, fileSize, attrib);
        finfo.setAllocationSize(allocSize);
        finfo.setFileId(fid);
        finfo.setShortName(shortName);
        if (createTime != 0L) {
            finfo.setCreationDateTime(NTTime.toSMBDate(createTime));
        }
        if (accessTime != 0L) {
            finfo.setAccessDateTime(NTTime.toSMBDate(accessTime));
        }
        if (writeTime != 0L) {
            finfo.setModifyDateTime(NTTime.toSMBDate(writeTime));
        }
        if (nextOff != 0) {
            this.m_dbuf.setPosition(startPos + nextOff);
        }
        ++this.m_dirIdx;
        return finfo;
    }

    private final FileInfo unpackFileNameInfo() {
        int nextOff = this.m_dbuf.getInt();
        int fid = this.m_dbuf.getInt();
        int nameLen = this.m_dbuf.getInt();
        if (this.m_rxtbuf.isUnicode()) {
            nameLen /= 2;
        }
        String fileName = this.m_dbuf.getString(nameLen, this.m_rxtbuf.isUnicode());
        FileInfo finfo = new FileInfo(fileName, 0L, 0);
        finfo.setFileId(fid);
        if (nextOff != 0) {
            this.m_dbuf.setPosition(nextOff);
        }
        ++this.m_dirIdx;
        return finfo;
    }

    protected final String unpackResumeName(int off) {
        if (off == 0) {
            return null;
        }
        int pos = this.m_dbuf.getPosition();
        this.m_dbuf.setPosition(off);
        String fname = null;
        int fnamelen = -1;
        switch (this.getInformationLevel()) {
            case 1: 
            case 2: {
                this.m_dbuf.skipBytes(-4);
                this.m_dbuf.getInt();
                this.m_dbuf.skipBytes(22);
                int bytlen = this.m_dbuf.getByte();
                fnamelen = bytlen++;
                if (this.m_rxtbuf.isUnicode()) {
                    fnamelen = bytlen / 2;
                    bytlen += 2;
                    this.m_dbuf.wordAlign();
                }
                fname = this.m_dbuf.getString(fnamelen, this.m_rxtbuf.isUnicode());
                break;
            }
            case 257: {
                this.m_dbuf.skipBytes(60);
                fnamelen = this.m_dbuf.getInt();
                fname = this.m_dbuf.getString(fnamelen / 2, this.m_rxtbuf.isUnicode());
                break;
            }
            case 258: {
                this.m_dbuf.skipBytes(60);
                fnamelen = this.m_dbuf.getInt();
                this.m_dbuf.skipBytes(4);
                fname = this.m_dbuf.getString(fnamelen / 2, this.m_rxtbuf.isUnicode());
                break;
            }
            case 260: {
                this.m_dbuf.skipBytes(60);
                fnamelen = this.m_dbuf.getInt();
                this.m_dbuf.skipBytes(30);
                fname = this.m_dbuf.getString(fnamelen / 2, this.m_rxtbuf.isUnicode());
            }
        }
        this.m_dbuf.setPosition(pos);
        return fname;
    }
}

