/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.client.admin;

import java.io.IOException;
import org.filesys.client.IPCSession;
import org.filesys.client.admin.IPCPipeFile;
import org.filesys.client.admin.ServiceHandle;
import org.filesys.client.admin.ServiceManagerHandle;
import org.filesys.smb.SMBException;
import org.filesys.smb.dcerpc.DCEBuffer;
import org.filesys.smb.dcerpc.DCEBufferException;
import org.filesys.smb.dcerpc.PolicyHandle;
import org.filesys.smb.dcerpc.client.DCEPacket;
import org.filesys.smb.dcerpc.info.ServiceConfigInfo;
import org.filesys.smb.dcerpc.info.ServiceStatusExList;
import org.filesys.smb.dcerpc.info.ServiceStatusInfo;
import org.filesys.smb.dcerpc.info.ServiceStatusList;
import org.filesys.util.StringList;

public class SvcctlPipeFile
extends IPCPipeFile {
    private ServiceManagerHandle m_handle = this.openServiceControlManager();

    public SvcctlPipeFile(IPCSession sess, DCEPacket pkt, int handle, String name, int maxTx, int maxRx) throws IOException, SMBException {
        super(sess, pkt, handle, name, maxTx, maxRx);
    }

    protected final ServiceManagerHandle openServiceControlManager() throws IOException, SMBException {
        return this.openServiceControlManager(983103);
    }

    protected final ServiceManagerHandle openServiceControlManager(int accessMode) throws IOException, SMBException {
        String remName = this.getSession().getPCShare().getNodeName();
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putPointer(true);
        buf.putString(remName, 1, true);
        buf.putPointer(false);
        buf.putInt(accessMode);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 15, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        DCEBuffer rxBuf = this.getRxBuffer();
        ServiceManagerHandle handle = new ServiceManagerHandle(remName);
        try {
            this.checkStatus(rxBuf.getStatusCode());
            rxBuf.getHandle(handle);
        }
        catch (DCEBufferException dCEBufferException) {
            // empty catch block
        }
        return handle;
    }

    public final ServiceHandle createService(String serviceName, String displayName, int svcType, int startType, int errCtrl, String binPath) throws IOException, SMBException {
        return this.createService(serviceName, displayName, svcType, startType, errCtrl, binPath, null, null, null, null);
    }

    public final ServiceHandle createService(String serviceName, String displayName, int svcType, int startType, int errCtrl, String binPath, String loadGrp, StringList depend, String account, byte[] password) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(this.getManagerHandle());
        buf.putString(serviceName, 1, true);
        if (displayName != null) {
            buf.putPointer(true);
            buf.putString(displayName, 1, true);
        } else {
            buf.putPointer(false);
        }
        buf.putInt(983103);
        buf.putInt(svcType);
        buf.putInt(startType);
        buf.putInt(errCtrl);
        buf.putString(binPath, 1, true);
        if (loadGrp != null) {
            buf.putPointer(true);
            buf.putString(loadGrp, 1, true);
        } else {
            buf.putPointer(false);
        }
        buf.putPointer(false);
        if (depend != null) {
            StringBuffer depList = new StringBuffer();
            for (int i = 0; i < depend.numberOfStrings(); ++i) {
                String curDep = depend.getStringAt(i);
                depList.append(curDep);
                depList.append('\u0000');
            }
            depList.append('\u0000');
            buf.putPointer(true);
            int bytLen = depList.length() * 2;
            buf.putInt(bytLen);
            buf.putUnicodeBytes(depList.toString(), 1);
            buf.putInt(bytLen);
        } else {
            buf.putPointer(false);
            buf.putPointer(false);
        }
        if (account != null) {
            buf.putPointer(true);
            buf.putString(account, 1, true);
        } else {
            buf.putPointer(false);
        }
        if (password != null) {
            buf.putPointer(true);
            buf.putInt(password.length);
        } else {
            buf.putPointer(false);
        }
        buf.putPointer(false);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 12, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        buf = this.getRxBuffer();
        ServiceHandle srvHandle = new ServiceHandle(serviceName);
        try {
            this.checkStatus(buf.getStatusCode());
            buf.getInt();
            buf.getHandle(srvHandle);
        }
        catch (DCEBufferException dCEBufferException) {
            // empty catch block
        }
        return srvHandle;
    }

    public final void deleteService(ServiceHandle handle) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(handle);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 2, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        buf = this.getRxBuffer();
        try {
            this.checkStatus(buf.getInt());
        }
        catch (DCEBufferException dCEBufferException) {
            // empty catch block
        }
    }

    public final ServiceHandle openService(String serviceName) throws IOException, SMBException {
        return this.openService(serviceName, 5);
    }

    public final ServiceHandle openService(String serviceName, int accessMode) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(this.getManagerHandle());
        buf.putString(serviceName, 1, true);
        buf.putInt(accessMode);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 16, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        buf = this.getRxBuffer();
        ServiceHandle srvHandle = new ServiceHandle(serviceName);
        try {
            this.checkStatus(buf.getStatusCode());
            buf.getHandle(srvHandle);
        }
        catch (DCEBufferException dCEBufferException) {
            // empty catch block
        }
        return srvHandle;
    }

    public final ServiceConfigInfo getServiceConfiguration(ServiceHandle handle) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(handle);
        buf.putInt(2048);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 17, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        DCEBuffer rxBuf = this.getRxBuffer();
        ServiceConfigInfo info = new ServiceConfigInfo();
        try {
            this.checkStatus(rxBuf.getStatusCode());
            info.readObject(rxBuf);
        }
        catch (DCEBufferException dCEBufferException) {
            // empty catch block
        }
        return info;
    }

    public final int setServiceConfiguration(ServiceHandle handle, ServiceConfigInfo config) throws IOException, SMBException, DCEBufferException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(handle);
        config.writeObject(buf, null);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 11, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        DCEBuffer rxBuf = this.getRxBuffer();
        this.checkStatus(rxBuf.getStatusCode());
        int tagId = -1;
        if (rxBuf.getPointer() != 0) {
            tagId = rxBuf.getInt();
        }
        return tagId;
    }

    public final ServiceStatusList getServiceList(int typ, int state) throws IOException, SMBException {
        ServiceStatusList stsList = new ServiceStatusList();
        int sts = -1;
        do {
            DCEBuffer buf = this.getBuffer();
            buf.resetBuffer();
            buf.putHandle(this.getManagerHandle());
            buf.putInt(typ);
            buf.putInt(state);
            buf.putInt(16384);
            buf.putPointer(true);
            buf.putInt(stsList.getMultiPartHandle());
            DCEPacket pkt = this.getPacket();
            try {
                pkt.initializeDCERequest(this.getHandle(), 14, buf, this.getMaximumTransmitSize(), this.getNextCallId());
            }
            catch (DCEBufferException ex) {
                ex.printStackTrace();
            }
            this.doDCERequest(pkt);
            sts = this.getRxBuffer().getStatusCode();
            try {
                stsList.readObject(this.getRxBuffer());
            }
            catch (DCEBufferException dCEBufferException) {
                // empty catch block
            }
        } while (sts == 234);
        return stsList;
    }

    public final ServiceStatusInfo getServiceStatus(ServiceHandle handle) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(handle);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 6, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        ServiceStatusInfo srvInfo = new ServiceStatusInfo();
        buf = this.getRxBuffer();
        try {
            this.checkStatus(buf.getStatusCode());
            srvInfo.readObject(buf);
        }
        catch (DCEBufferException dCEBufferException) {
            // empty catch block
        }
        return srvInfo;
    }

    public final void startService(ServiceHandle handle) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(handle);
        buf.putInt(0);
        buf.putPointer(false);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 19, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
    }

    public final void stopService(ServiceHandle handle) throws IOException, SMBException {
        this.controlService(handle, 1);
    }

    public final void pauseService(ServiceHandle handle) throws IOException, SMBException {
        this.controlService(handle, 2);
    }

    public final void resumeService(ServiceHandle handle) throws IOException, SMBException {
        this.controlService(handle, 3);
    }

    public final void controlService(ServiceHandle handle, int ctrl) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(handle);
        buf.putInt(ctrl);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 1, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        this.checkStatus(this.getRxBuffer().getStatusCode());
    }

    public final void closeService(ServiceHandle handle) throws IOException, SMBException {
        this.closeHandle(handle);
    }

    protected final void closeServiceManager(ServiceManagerHandle handle) throws IOException, SMBException {
        this.closeHandle(handle);
    }

    protected final ServiceManagerHandle getManagerHandle() {
        return this.m_handle;
    }

    @Override
    public void ClosePipe() throws IOException, SMBException {
        if (this.getManagerHandle() != null) {
            this.closeServiceManager(this.m_handle);
            this.m_handle = null;
        }
        super.ClosePipe();
    }

    private final void closeHandle(PolicyHandle handle) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(handle);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 0, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.getSession().SendTransaction(pkt, pkt);
        if (!pkt.isValidResponse()) {
            throw new SMBException(6, pkt.getLongErrorCode());
        }
    }

    public final ServiceStatusExList getServiceListEx(int typ, int state) throws IOException, SMBException {
        ServiceStatusExList stsList = new ServiceStatusExList();
        int sts = -1;
        do {
            DCEBuffer buf = this.getBuffer();
            buf.resetBuffer();
            buf.putHandle(this.getManagerHandle());
            buf.putInt(0);
            buf.putInt(typ);
            buf.putInt(state);
            buf.putInt(16384);
            buf.putPointer(true);
            buf.putInt(stsList.getMultiPartHandle());
            buf.putPointer(false);
            DCEPacket pkt = this.getPacket();
            try {
                pkt.initializeDCERequest(this.getHandle(), 42, buf, this.getMaximumTransmitSize(), this.getNextCallId());
            }
            catch (DCEBufferException ex) {
                ex.printStackTrace();
            }
            this.doDCERequest(pkt);
            sts = this.getRxBuffer().getStatusCode();
            try {
                stsList.readObject(this.getRxBuffer());
            }
            catch (DCEBufferException dCEBufferException) {
                // empty catch block
            }
        } while (sts == 234);
        return stsList;
    }
}

