/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.debug.cluster;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Member;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.filesys.debug.DebugInterface;
import org.filesys.debug.DebugInterfaceBase;
import org.filesys.debug.cluster.DebugClusterMessage;
import org.filesys.server.config.InvalidConfigurationException;
import org.filesys.server.config.ServerConfiguration;
import org.filesys.server.filesys.cache.hazelcast.ClusterConfigSection;
import org.springframework.extensions.config.ConfigElement;

public class ClusterDebug
extends DebugInterfaceBase
implements MessageListener<DebugClusterMessage> {
    public static final String DefaultTopicName = "JFileSrvDebug";
    private ClusterConfigSection m_clusterConfig;
    private String m_debugTopicName = "JFileSrvDebug";
    private ITopic<DebugClusterMessage> m_debugTopic;
    private Member m_localNode;
    private String m_localName;
    private boolean m_receiveOnly;
    private DebugInterface m_localInterface;
    private StringBuilder m_printBuf;
    private String m_prefix;

    @Override
    public void initialize(ConfigElement params, ServerConfiguration config) throws Exception {
        super.initialize(params, config);
        this.m_clusterConfig = (ClusterConfigSection)config.getConfigSection("HazelcastCluster");
        if (this.m_clusterConfig == null) {
            throw new InvalidConfigurationException("Cluster configuration not available");
        }
        this.m_printBuf = new StringBuilder(256);
        ConfigElement elem = params.getChild("debugTopic");
        if (elem != null && elem.getValue() != null) {
            this.m_debugTopicName = elem.getValue();
            if (this.m_debugTopicName == null || this.m_debugTopicName.length() == 0) {
                throw new InvalidConfigurationException("Empty cluster name");
            }
        }
        if (params.getChild("receiveOnly") != null) {
            this.m_receiveOnly = true;
        }
        if ((elem = params.getChild("localOutput")) != null) {
            ConfigElement debugClass = elem.getChild("class");
            if (debugClass == null) {
                throw new InvalidConfigurationException("Class must be specified for debug output");
            }
            Object obj = Class.forName(debugClass.getValue()).newInstance();
            if (obj instanceof DebugInterface) {
                this.m_localInterface = (DebugInterface)obj;
                this.m_localInterface.initialize(elem, config);
            } else {
                throw new InvalidConfigurationException("Local debug class " + debugClass.getValue() + " does not implement DebugInterface");
            }
        }
        HazelcastInstance hzInstance = this.m_clusterConfig.getHazelcastInstance();
        this.m_debugTopic = hzInstance.getTopic(this.m_debugTopicName);
        if (this.m_debugTopic == null) {
            throw new Exception("Failed to initialize cluster topic, " + this.m_debugTopicName);
        }
        this.m_localNode = hzInstance.getCluster().getLocalMember();
        this.m_localName = this.m_localNode.getSocketAddress().toString();
        this.m_debugTopic.addMessageListener((MessageListener)this);
        this.m_prefix = "{" + this.m_localNode.getSocketAddress().getHostName() + ":" + this.m_localNode.getSocketAddress().getPort() + "} ";
    }

    @Override
    public void close() {
        this.m_debugTopic = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void debugPrint(String str, int level) {
        if (level <= this.getLogLevel()) {
            boolean startOfLine = false;
            StringBuilder stringBuilder = this.m_printBuf;
            synchronized (stringBuilder) {
                if (this.m_printBuf.length() == 0) {
                    startOfLine = true;
                }
                this.m_printBuf.append(str);
            }
            if (this.m_localInterface != null) {
                if (startOfLine) {
                    this.m_localInterface.debugPrint(this.m_prefix);
                }
                this.m_localInterface.debugPrint(str, level);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void debugPrintln(String str, int level) {
        if (level <= this.getLogLevel()) {
            boolean startOfLine = true;
            if (this.m_printBuf.length() > 0) {
                StringBuilder stringBuilder = this.m_printBuf;
                synchronized (stringBuilder) {
                    startOfLine = false;
                    this.m_printBuf.append(str);
                    this.logToCluster(this.m_printBuf.toString());
                    this.m_printBuf.setLength(0);
                }
            } else {
                this.logToCluster(str);
            }
            if (this.m_localInterface != null) {
                if (startOfLine) {
                    this.m_localInterface.debugPrint(this.m_prefix);
                }
                this.m_localInterface.debugPrintln(str, level);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void debugPrintln(Exception ex, int level) {
        if (level <= this.getLogLevel()) {
            StringWriter strWrt = new StringWriter();
            ex.printStackTrace(new PrintWriter((Writer)strWrt, true));
            String traceString = strWrt.toString();
            if (this.m_printBuf.length() > 0) {
                StringBuilder stringBuilder = this.m_printBuf;
                synchronized (stringBuilder) {
                    this.m_printBuf.append(traceString);
                    this.logToCluster(this.m_printBuf.toString());
                    this.m_printBuf.setLength(0);
                }
            } else {
                this.logToCluster(traceString);
            }
            if (this.m_localInterface != null) {
                this.m_localInterface.debugPrint(this.m_prefix);
                this.m_localInterface.debugPrintln(traceString, level);
            }
        }
    }

    protected void logToCluster(String str) {
        if (this.m_receiveOnly || this.m_debugTopic == null) {
            return;
        }
        this.m_debugTopic.publish((Object)new DebugClusterMessage(this.m_localName, this.m_prefix + str));
    }

    public void onMessage(Message<DebugClusterMessage> msg) {
        if (this.m_localInterface != null) {
            this.m_localInterface.debugPrintln(((DebugClusterMessage)msg.getMessageObject()).getDebugString());
        }
    }
}

