/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.ftp;

import java.util.HashMap;
import java.util.Map;

public enum FTPCommand {
    USER(0),
    PASS(1),
    ACCT(2),
    CWD(3),
    CDUP(4),
    SMNT(5),
    REIN(6),
    QUIT(7),
    PORT(8),
    PASV(9),
    TYPE(10),
    STRU(11),
    MODE(12),
    RETR(13),
    STOR(14),
    STOU(15),
    APPE(16),
    ALLO(17),
    REST(18),
    RNFR(19),
    RNTO(20),
    ABOR(21),
    DELE(22),
    RMD(23),
    MKD(24),
    PWD(25),
    LIST(26),
    NLST(27),
    SITE(28),
    SYST(29),
    STAT(30),
    HELP(31),
    NOOP(32),
    MDTM(33),
    SIZE(34),
    OPTS(35),
    FEAT(36),
    XPWD(37),
    XMKD(38),
    XRMD(39),
    XCUP(40),
    XCWD(41),
    MLST(42),
    MLSD(43),
    EPRT(44),
    EPSV(45),
    AUTH(46),
    PBSZ(47),
    PROT(48),
    CCC(49),
    MFMT(50),
    INVALID_CMD(-1);

    private static Map<String, FTPCommand> _idMap;
    private final int ftpCmd;

    private FTPCommand(int cmd) {
        this.ftpCmd = cmd;
    }

    public static final FTPCommand getCommandId(String cmd) {
        FTPCommand ftpCmd = _idMap.get(cmd.toUpperCase());
        if (ftpCmd == null) {
            return INVALID_CMD;
        }
        return ftpCmd;
    }

    static {
        _idMap = new HashMap<String, FTPCommand>();
        for (FTPCommand cmd : FTPCommand.values()) {
            _idMap.put(cmd.name(), cmd);
        }
    }
}

