/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.ftp;

import org.filesys.ftp.FTPCommand;

public class FTPRequest {
    private FTPCommand m_cmd;
    private String m_arg;

    public FTPRequest() {
        this.m_cmd = FTPCommand.INVALID_CMD;
    }

    public FTPRequest(FTPCommand cmd, String arg) {
        this.m_cmd = cmd;
        this.m_arg = arg;
    }

    public FTPRequest(String cmdLine) {
        this.parseCommandLine(cmdLine);
    }

    public final FTPCommand isCommand() {
        return this.m_cmd;
    }

    public final boolean hasArgument() {
        return this.m_arg != null;
    }

    public final String getArgument() {
        return this.m_arg;
    }

    public final FTPCommand setCommandLine(String cmdLine) {
        this.m_cmd = FTPCommand.INVALID_CMD;
        this.m_arg = null;
        this.parseCommandLine(cmdLine);
        return this.isCommand();
    }

    protected final void parseCommandLine(String cmdLine) {
        int pos = cmdLine.indexOf(32);
        String cmd = null;
        if (pos != -1) {
            cmd = cmdLine.substring(0, pos);
            this.m_arg = cmdLine.substring(pos + 1);
        } else {
            cmd = cmdLine;
        }
        this.m_cmd = FTPCommand.getCommandId(cmd);
    }

    protected final void updateArgument(String arg) {
        this.m_arg = arg;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.m_cmd.name());
        str.append(":");
        str.append(this.m_arg);
        str.append("]");
        return str.toString();
    }
}

