/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc;

import java.io.IOException;
import java.net.Socket;
import org.filesys.oncrpc.MultiThreadedTcpRpcSessionHandler;
import org.filesys.oncrpc.RpcPacket;
import org.filesys.oncrpc.RpcPacketHandler;
import org.filesys.oncrpc.RpcProcessor;
import org.filesys.oncrpc.TcpRpcPacketHandler;
import org.filesys.oncrpc.TcpRpcSessionHandler;

public class MultiThreadedTcpRpcPacketHandler
extends TcpRpcPacketHandler
implements RpcPacketHandler {
    public MultiThreadedTcpRpcPacketHandler(TcpRpcSessionHandler handler, int sessId, RpcProcessor server, Socket socket, int maxRpcSize) throws IOException {
        super(handler, sessId, server, socket, maxRpcSize);
    }

    protected final MultiThreadedTcpRpcSessionHandler getSessionHandler() {
        return (MultiThreadedTcpRpcSessionHandler)this.getHandler();
    }

    @Override
    protected RpcPacket allocateRpcPacket(int maxSize) {
        return this.getSessionHandler().allocateRpcPacket(maxSize);
    }

    @Override
    protected void deallocateRpcPacket(RpcPacket pkt) {
        if (pkt.isAllocatedFromPool()) {
            pkt.getOwnerPacketPool().releasePacket(pkt);
        }
    }

    @Override
    protected void processRpc(RpcPacket rpc) throws IOException {
        rpc.setPacketHandler(this);
        this.getSessionHandler().queueRpcRequest(rpc);
    }

    @Override
    public void sendRpcResponse(RpcPacket rpc) throws IOException {
        this.sendRpc(rpc);
    }
}

